/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.ollama;

import java.util.ArrayList;
import java.util.List;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.TypeRef;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.embedding.Embedding;
import org.noear.solon.ai.embedding.EmbeddingConfig;
import org.noear.solon.ai.embedding.EmbeddingException;
import org.noear.solon.ai.embedding.EmbeddingResponse;
import org.noear.solon.ai.embedding.dialect.AbstractEmbeddingDialect;

public class OllamaEmbeddingDialect
extends AbstractEmbeddingDialect {
    private static OllamaEmbeddingDialect instance = new OllamaEmbeddingDialect();

    public static OllamaEmbeddingDialect getInstance() {
        return instance;
    }

    public boolean matched(EmbeddingConfig config) {
        return "ollama".equals(config.getProvider());
    }

    public EmbeddingResponse parseResponseJson(EmbeddingConfig config, String respJson) {
        ONode oResp = ONode.ofJson((String)respJson, (Feature[])new Feature[0]);
        String model = oResp.get("model").getString();
        if (oResp.hasKey("error")) {
            return new EmbeddingResponse(model, new EmbeddingException(oResp.get("error").getString()), null, null);
        }
        ArrayList<Embedding> data = new ArrayList<Embedding>();
        int dataIndex = 0;
        for (float[] embed : (List)oResp.get("embeddings").toBean((TypeRef)new TypeRef<List<float[]>>(){})) {
            data.add(new Embedding(dataIndex, embed));
            ++dataIndex;
        }
        AiUsage usage = null;
        if (oResp.hasKey("prompt_eval_count")) {
            long prompt_eval_count = oResp.get("prompt_eval_count").getLong();
            usage = new AiUsage(prompt_eval_count, 0L, prompt_eval_count, oResp);
        }
        return new EmbeddingResponse(model, null, data, usage);
    }
}

