/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.ollama;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.chat.ChatChoice;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatException;
import org.noear.solon.ai.chat.ChatResponseDefault;
import org.noear.solon.ai.chat.dialect.AbstractChatDialect;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.UserMessage;
import org.noear.solon.ai.chat.tool.ToolCall;
import org.noear.solon.ai.chat.tool.ToolCallBuilder;
import org.noear.solon.ai.media.Audio;
import org.noear.solon.ai.media.Image;
import org.noear.solon.ai.media.Video;
import org.noear.solon.core.util.DateUtil;

public class OllamaChatDialect
extends AbstractChatDialect {
    private static OllamaChatDialect instance = new OllamaChatDialect();

    public static OllamaChatDialect getInstance() {
        return instance;
    }

    public boolean matched(ChatConfig config) {
        return "ollama".equals(config.getProvider());
    }

    protected void buildChatMessageNodeDo(ONode oNode, UserMessage msg) {
        oNode.set("role", (Object)msg.getRole().name().toLowerCase());
        if (Utils.isEmpty((Collection)msg.getMedias())) {
            oNode.set("content", (Object)msg.getContent());
        } else {
            oNode.set("content", (Object)msg.getContent());
            AiMedia demo = (AiMedia)msg.getMedias().get(0);
            if (demo instanceof Image) {
                oNode.set("images", msg.getMedias().stream().map(i -> i.toDataString(false)).collect(Collectors.toList()));
            } else if (demo instanceof Audio) {
                oNode.set("audios", msg.getMedias().stream().map(i -> i.toDataString(false)).collect(Collectors.toList()));
            } else if (demo instanceof Video) {
                oNode.set("videos", msg.getMedias().stream().map(i -> i.toDataString(false)).collect(Collectors.toList()));
            }
        }
    }

    public ONode buildAssistantMessageNode(Map<Integer, ToolCallBuilder> toolCallBuilders) {
        ONode oNode = new ONode();
        oNode.set("role", (Object)"assistant");
        oNode.set("content", (Object)"");
        oNode.getOrNew("tool_calls").asArray().then(n1 -> {
            for (Map.Entry kv : toolCallBuilders.entrySet()) {
                n1.addNew().set("id", (Object)((ToolCallBuilder)kv.getValue()).idBuilder.toString()).set("type", (Object)"function").getOrNew("function").then(n2 -> {
                    n2.set("name", (Object)((ToolCallBuilder)kv.getValue()).nameBuilder.toString());
                    n2.set("arguments", (Object)ONode.ofJson((String)((ToolCallBuilder)kv.getValue()).argumentsBuilder.toString(), (Feature[])new Feature[0]));
                });
            }
        });
        return oNode;
    }

    public boolean parseResponseJson(ChatConfig config, ChatResponseDefault resp, String json) {
        ONode oResp = ONode.ofJson((String)json, (Feature[])new Feature[0]);
        if (!oResp.isObject()) {
            return false;
        }
        if (oResp.hasKey("error")) {
            resp.setError(new ChatException(oResp.get("error").getString()));
        } else {
            resp.setModel(oResp.get("model").getString());
            resp.setFinished(oResp.get("done").getBoolean().booleanValue());
            String done_reason = oResp.get("done_reason").getString();
            String createdStr = oResp.get("created_at").getString();
            if (createdStr != null) {
                createdStr = createdStr.substring(0, createdStr.indexOf(".") + 4);
            }
            Date created = DateUtil.parseTry((String)createdStr);
            List messageList = this.parseAssistantMessage(resp, oResp.get("message"));
            for (AssistantMessage msg1 : messageList) {
                resp.addChoice(new ChatChoice(0, created, done_reason, msg1));
            }
            if (resp.isFinished()) {
                long promptTokens = oResp.get("prompt_eval_count").getLong();
                long completionTokens = oResp.get("eval_count").getLong();
                long totalTokens = promptTokens + completionTokens;
                resp.setUsage(new AiUsage(promptTokens, completionTokens, totalTokens, oResp));
                if (!resp.hasChoices()) {
                    resp.addChoice(new ChatChoice(0, created, "stop", new AssistantMessage("")));
                }
            }
        }
        return true;
    }

    protected ToolCall parseToolCall(ONode n1) {
        int index = -1;
        String callId = n1.get("id").getString();
        ONode n1f = n1.get("function");
        String name = n1f.get("name").getString();
        ONode n1fArgs = n1f.get("arguments");
        String argStr = n1fArgs.getString();
        index = name.hashCode();
        if (n1fArgs.isValue()) {
            n1fArgs = ONode.ofJson((String)argStr, (Feature[])new Feature[0]);
        }
        Map argMap = null;
        if (n1fArgs.isObject()) {
            argMap = (Map)n1fArgs.toBean(Map.class);
        }
        return new ToolCall(index, callId, name, argStr, argMap);
    }
}

