/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.encode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.EncodeContext;
import org.noear.snack4.codec.ObjectPatternEncoder;
import org.noear.snack4.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class _PropertiesPatternEncoder
implements ObjectPatternEncoder<Properties> {
    static final Logger log = LoggerFactory.getLogger(_PropertiesPatternEncoder.class);

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Properties;
    }

    @Override
    public ONode encode(EncodeContext ctx, Properties props, ONode target) {
        if (props.size() == 0) {
            return target;
        }
        ArrayList keyVector = new ArrayList();
        props.keySet().forEach(k -> {
            if (k instanceof String) {
                keyVector.add((String)k);
            }
        });
        Collections.sort(keyVector);
        if (((String)keyVector.get(0)).startsWith("[")) {
            target.asArray();
        } else {
            target.asObject();
        }
        for (String key : keyVector) {
            String val = props.getProperty(key);
            try {
                _PropertiesPatternEncoder.setNestedValue(target, key, val);
            }
            catch (Exception e) {
                log.warn("Failed to encode property '{}'. The value: '{}'", new Object[]{key, val, e});
            }
        }
        return target;
    }

    public static void setNestedValue(ONode target, String key, String val) {
        String[] keySegments = key.split("\\.");
        ONode n1 = target;
        for (int i = 0; i < keySegments.length; ++i) {
            String p1 = keySegments[i];
            if (p1.endsWith("]")) {
                String tmp = p1.substring(p1.lastIndexOf(91) + 1, p1.length() - 1);
                p1 = p1.substring(0, p1.lastIndexOf(91));
                if (tmp.length() > 0) {
                    if (Asserts.isInteger(tmp)) {
                        int idx = Integer.parseInt(tmp);
                        if (p1.length() > 0) {
                            n1 = n1.getOrNew(p1).getOrNew(idx);
                            continue;
                        }
                        n1 = n1.getOrNew(idx);
                        continue;
                    }
                    if (tmp.length() > 2 && (tmp.indexOf(39) == 0 || tmp.indexOf(34) == 0)) {
                        tmp = tmp.substring(1, tmp.length() - 1);
                    }
                    if (p1.length() > 0) {
                        n1 = n1.getOrNew(p1).getOrNew(tmp);
                        continue;
                    }
                    n1 = n1.getOrNew(tmp);
                    continue;
                }
                if (p1.length() > 0) {
                    n1 = n1.getOrNew(p1).addNew();
                    continue;
                }
                n1 = n1.addNew();
                continue;
            }
            n1 = n1.getOrNew(p1);
        }
        n1.setValue(val);
    }
}

