/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.encode;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.EncodeContext;
import org.noear.snack4.codec.ObjectEncoder;
import org.noear.snack4.util.Asserts;

public class ZonedDateTimeEncoder
implements ObjectEncoder<ZonedDateTime> {
    @Override
    public ONode encode(EncodeContext ctx, ZonedDateTime value, ONode target) {
        if (ctx.getAttr() != null && Asserts.isNotEmpty(ctx.getAttr().getFormat())) {
            DateTimeFormatter f = DateTimeFormatter.ofPattern(ctx.getAttr().getFormat());
            return target.setValue(f.format(value));
        }
        return target.setValue(Date.from(value.toInstant()));
    }
}

