/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec.decode;

import org.noear.eggg.ConstrEggg;
import org.noear.eggg.ParamEggg;
import org.noear.snack4.ONode;
import org.noear.snack4.SnackException;
import org.noear.snack4.codec.DecodeContext;
import org.noear.snack4.codec.ObjectPatternDecoder;
import org.noear.snack4.codec.util.EnumWrap;

public class _EnumPatternDecoder
implements ObjectPatternDecoder<Object> {
    @Override
    public boolean canDecode(Class<?> clazz) {
        return clazz.isEnum();
    }

    @Override
    public Object decode(DecodeContext ctx, ONode node) {
        ConstrEggg constrEggg = ctx.getTypeEggg().getClassEggg().getCreator();
        Enum eItem = null;
        if (constrEggg != null && constrEggg.isStatic()) {
            if (constrEggg.getParamCount() != 1) {
                throw new SnackException("Enum creator must be 1 param: " + ctx.getType().getTypeName());
            }
            try {
                ParamEggg p1 = constrEggg.getParamEgggAt(0);
                Object arg1 = node.isObject() ? node.get(p1.getName()).toBean(p1.getType()) : node.toBean(p1.getType());
                eItem = (Enum)constrEggg.newInstance(new Object[]{arg1});
            }
            catch (Exception e) {
                throw new SnackException("Decode failure for '" + ctx.getType().getTypeName() + "' from value: " + node.getString(), e);
            }
        } else {
            EnumWrap ew = EnumWrap.from(ctx.getType());
            if (ew.hasCustom()) {
                eItem = ew.getCustom(node.getString());
                if (eItem == null) {
                    eItem = ew.get(node.getString());
                }
            } else {
                eItem = node.isNumber() ? ew.get(node.getInt()) : ew.get(node.getString());
            }
        }
        if (eItem == null) {
            throw new SnackException("Decode failure for '" + ctx.getType().getTypeName() + "' from value: " + node.getString());
        }
        return eItem;
    }
}

