/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.eggg.GenericResolver;

public abstract class TypeRef<T> {
    private final Type initialType;
    private Map<String, Type> genericInfo;

    protected TypeRef() {
        Type sc = this.getClass().getGenericSuperclass();
        this.initialType = ((ParameterizedType)sc).getActualTypeArguments()[0];
    }

    protected TypeRef(Type initialType, Map<String, Type> genericInfo) {
        this.initialType = initialType;
        this.genericInfo = genericInfo;
    }

    public TypeRef<T> where(String typeVar, Type type) {
        if (this.genericInfo == null) {
            this.genericInfo = new HashMap<String, Type>();
        }
        this.genericInfo.put(typeVar, type);
        return this;
    }

    public Type getType() {
        return TypeRef.resolveType(this.initialType, this.genericInfo);
    }

    private static Type resolveType(Type type, Map<String, Type> genericInfo) {
        if (genericInfo != null && genericInfo.size() > 0) {
            if (type instanceof TypeVariable) {
                TypeVariable typeVar = (TypeVariable)type;
                String name = typeVar.getName();
                if (genericInfo.containsKey(name)) {
                    return genericInfo.get(name);
                }
                return type;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                Type rawType = pt.getRawType();
                Type ownerType = pt.getOwnerType();
                Type[] args = pt.getActualTypeArguments();
                Type[] resolvedArgs = new Type[args.length];
                boolean changed = false;
                for (int i = 0; i < args.length; ++i) {
                    resolvedArgs[i] = TypeRef.resolveType(args[i], genericInfo);
                    if (resolvedArgs[i] == args[i]) continue;
                    changed = true;
                }
                if (changed) {
                    return new GenericResolver.ParameterizedTypeImpl((Class)rawType, resolvedArgs, ownerType);
                }
                return type;
            }
        }
        return type;
    }

    public static <E> TypeRef<List<E>> listOf(Class<E> elementType) {
        return new TypeRef<List<E>>((Type)new GenericResolver.ParameterizedTypeImpl(List.class, new Type[]{elementType}), null){};
    }

    public static <E> TypeRef<Set<E>> setOf(Class<E> elementType) {
        return new TypeRef<Set<E>>((Type)new GenericResolver.ParameterizedTypeImpl(Set.class, new Type[]{elementType}), null){};
    }

    public static <K, V> TypeRef<Map<K, V>> mapOf(Class<K> keyType, Class<V> valueType) {
        return new TypeRef<Map<K, V>>((Type)new GenericResolver.ParameterizedTypeImpl(Map.class, new Type[]{keyType, valueType}), null){};
    }
}

