/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.codec;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.ConstrEggg;
import org.noear.eggg.ParamEggg;
import org.noear.eggg.Property;
import org.noear.eggg.PropertyEggg;
import org.noear.eggg.TypeEggg;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.Options;
import org.noear.snack4.annotation.ONodeAttrHolder;
import org.noear.snack4.codec.CodecException;
import org.noear.snack4.codec.DecodeContext;
import org.noear.snack4.codec.ObjectCreator;
import org.noear.snack4.codec.ObjectDecoder;
import org.noear.snack4.codec.util.ClassUtil;
import org.noear.snack4.codec.util.EgggUtil;
import org.noear.snack4.util.Asserts;

public class BeanDecoder {
    private final ONode source0;
    private final Type targetType0;
    private final Object target0;
    private final Options opts;
    private final boolean onlyUseSetter;
    private final boolean allowUseSetter;

    public static <T> T decode(ONode node, Type type) {
        return BeanDecoder.decode(node, type, null, null);
    }

    public static <T> T decode(ONode node, Type type, Object target, Options opts) {
        if (node == null || type == null) {
            return null;
        }
        return new BeanDecoder(node, type, target, opts).decode();
    }

    private BeanDecoder(ONode source, Type type, Object target, Options opts) {
        this.source0 = source;
        this.targetType0 = type;
        this.target0 = target;
        this.opts = opts == null ? Options.DEF_OPTIONS : opts;
        this.onlyUseSetter = this.opts.hasFeature(Feature.Write_OnlyUseSetter);
        this.allowUseSetter = this.onlyUseSetter || this.opts.hasFeature(Feature.Write_AllowUseSetter);
    }

    public <T> T decode() {
        TypeEggg typeEggg = EgggUtil.getTypeEggg(this.targetType0);
        try {
            return (T)this.decodeValueFromNode(this.source0, typeEggg, this.target0, null);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CodecException("Failed to decode bean from ONode", e);
        }
    }

    private Object decodeValueFromNode(ONode node, TypeEggg typeEggg, Object target, ONodeAttrHolder attr) throws Throwable {
        if (node.isNull()) {
            return null;
        }
        ObjectDecoder<?> decoder = this.opts.getDecoder((typeEggg = this.confirmNodeType(node, typeEggg)).getType());
        if (decoder != null) {
            return decoder.decode(new DecodeContext<Object>(this.opts, attr, target, typeEggg), node);
        }
        if (node.isValue()) {
            if ((typeEggg.getType().isInterface() || Modifier.isAbstract(typeEggg.getType().getModifiers())) && node.isString() && node.getString().indexOf(46) > 0) {
                Class<?> clz = this.opts.loadClass(node.getString());
                if (clz == null) {
                    return null;
                }
                return ClassUtil.newInstance(clz);
            }
            if (!((Collection.class.isAssignableFrom(typeEggg.getType()) || typeEggg.getType().isArray()) && node.isString())) {
                return node.getValue();
            }
        }
        if (target == null) {
            ObjectCreator<?> creator = this.opts.getCreator(typeEggg.getType());
            if (creator != null) {
                target = creator.create(this.opts, node, typeEggg.getType());
            }
            if (target == null) {
                if (typeEggg.getType().isInterface()) {
                    if (node.isEmpty()) {
                        return null;
                    }
                    throw new CodecException("can not convert bean to type: " + typeEggg.getType());
                }
                ConstrEggg constrEggg = typeEggg.getClassEggg().getCreator();
                if (constrEggg == null) {
                    throw new CodecException("Create instance failed: " + typeEggg.getType().getName());
                }
                if (constrEggg.getParamCount() == 0) {
                    target = constrEggg.newInstance(new Object[0]);
                } else {
                    if (!(constrEggg.isSecurity() || this.opts.hasFeature(Feature.Write_AllowParameterizedConstructor) || typeEggg.getClassEggg().isLikeRecordClass())) {
                        throw new CodecException("Parameterized constructor are not allowed: " + typeEggg.getType());
                    }
                    Object[] args = this.getConstrArgs(constrEggg, node);
                    target = constrEggg.newInstance(args);
                }
            }
        }
        if (target instanceof Map) {
            target = this.decodeMapFromNode(node, typeEggg, target);
        } else if (target instanceof Collection) {
            target = this.decodeCollectionFromNode(node, typeEggg, target);
        } else {
            return this.decodeBeanFromNode(node, typeEggg, target);
        }
        return target;
    }

    private Object decodeBeanFromNode(ONode node, TypeEggg typeEggg, Object target) throws Throwable {
        boolean failOnUnknownProperties = this.opts.hasFeature(Feature.Write_FailOnUnknownProperties);
        ClassEggg classEggg = typeEggg.getClassEggg();
        if (failOnUnknownProperties) {
            for (Map.Entry<String, ONode> kv : node.getObject().entrySet()) {
                if (kv.getKey().startsWith(this.opts.getTypePropertyName()) || classEggg.getCreator() != null && classEggg.getCreator().hasParamEgggByAlias(kv.getKey())) continue;
                PropertyEggg pe = classEggg.getPropertyEgggByAlias(kv.getKey());
                if (pe != null) {
                    this.decodeBeanPropertyFromNode(node, pe, target);
                    continue;
                }
                throw new CodecException("Unknown property : " + kv.getKey());
            }
        } else {
            for (PropertyEggg pe : classEggg.getPropertyEgggs()) {
                if (classEggg.getCreator() != null && classEggg.getCreator().getParamCount() > 0 && classEggg.getCreator().hasParamEgggByAlias(pe.getAlias())) continue;
                this.decodeBeanPropertyFromNode(node, pe, target);
            }
        }
        return target;
    }

    private void decodeBeanPropertyFromNode(ONode node, PropertyEggg pe, Object target) throws Throwable {
        Object property = this.onlyUseSetter ? pe.getSetterEggg() : (this.allowUseSetter && pe.getSetterEggg() != null ? pe.getSetterEggg() : pe.getFieldEggg());
        this.decodeBeanPropertyFromNode0(node, (Property)property, target);
    }

    private void decodeBeanPropertyFromNode0(ONode node, Property property, Object target) throws Throwable {
        ONode oNode;
        if (property == null || property.isTransient() || !((ONodeAttrHolder)property.getDigest()).isDecode()) {
            return;
        }
        ONode oNode2 = oNode = ((ONodeAttrHolder)property.getDigest()).isFlat() ? node : node.get(property.getAlias());
        if (oNode != null && !oNode.isNull()) {
            Object exisValue = property.getValue(target);
            Object propValue = null;
            propValue = ((ONodeAttrHolder)property.getDigest()).getDecoder() != null ? ((ONodeAttrHolder)property.getDigest()).getDecoder().decode(new DecodeContext<Object>(this.opts, (ONodeAttrHolder)property.getDigest(), exisValue, property.getTypeEggg()), oNode) : this.decodeValueFromNode(oNode, property.getTypeEggg(), exisValue, (ONodeAttrHolder)property.getDigest());
            property.setValue(target, propValue);
        }
    }

    private Collection decodeCollectionFromNode(ONode node, TypeEggg typeEggg, Object target) throws Throwable {
        Object elementType = Object.class;
        if (typeEggg.isParameterizedType()) {
            elementType = typeEggg.getActualTypeArguments()[0];
        }
        if (elementType instanceof WildcardType) {
            WildcardType tmp = (WildcardType)elementType;
            elementType = Asserts.isEmpty(tmp.getLowerBounds()) ? tmp.getUpperBounds()[0] : tmp.getLowerBounds()[0];
        }
        AbstractCollection coll = (ArrayList)target;
        if (node.isArray()) {
            if (coll == Collections.EMPTY_LIST) {
                coll = new ArrayList();
            } else if (coll == Collections.EMPTY_SET) {
                coll = new HashSet();
            }
            TypeEggg elementTypeEggg = EgggUtil.getTypeEggg((Type)elementType);
            for (ONode n1 : node.getArray()) {
                Object item = this.decodeValueFromNode(n1, elementTypeEggg, null, null);
                if (item == null) continue;
                coll.add(item);
            }
        } else if (node.isString()) {
            if (coll == Collections.EMPTY_LIST) {
                coll = new ArrayList();
            } else if (coll == Collections.EMPTY_SET) {
                coll = new HashSet();
            }
            String[] strArray = node.toString().split(",");
            TypeEggg elementTypeEggg = EgggUtil.getTypeEggg((Type)elementType);
            for (String str : strArray) {
                Object item = this.decodeValueFromNode(new ONode(this.opts, str), elementTypeEggg, null, null);
                if (item == null) continue;
                coll.add(item);
            }
        } else {
            throw new CodecException("The type of node " + (Object)((Object)node.type()) + " cannot be converted to collection.");
        }
        return coll;
    }

    private Map decodeMapFromNode(ONode node, TypeEggg targetTypeEggg, Object target) throws Throwable {
        if (node.isObject()) {
            Object keyType = Object.class;
            Object valueType = Object.class;
            if (targetTypeEggg.isParameterizedType()) {
                keyType = targetTypeEggg.getActualTypeArguments()[0];
                valueType = targetTypeEggg.getActualTypeArguments()[1];
            }
            if (valueType instanceof WildcardType) {
                WildcardType tmp = (WildcardType)valueType;
                valueType = Asserts.isEmpty(tmp.getLowerBounds()) ? tmp.getUpperBounds()[0] : tmp.getLowerBounds()[0];
            }
            TypeEggg keyTypeEggg = EgggUtil.getTypeEggg(keyType);
            TypeEggg valueTypeEggg = EgggUtil.getTypeEggg(valueType);
            LinkedHashMap<Object, Object> map = null;
            map = target != Collections.EMPTY_MAP ? (LinkedHashMap<Object, Object>)target : new LinkedHashMap<Object, Object>();
            for (Map.Entry<String, ONode> kv : node.getObject().entrySet()) {
                if (this.opts.hasFeature(Feature.Read_AutoType) && kv.getKey().startsWith(this.opts.getTypePropertyName())) continue;
                Object k = this.decodeKey(kv.getKey(), keyTypeEggg);
                Object v = this.decodeValueFromNode(kv.getValue(), valueTypeEggg, null, null);
                map.put(k, v);
            }
            return map;
        }
        throw new CodecException("The type of node " + (Object)((Object)node.type()) + " cannot be converted to map.");
    }

    private Object decodeKey(String key, TypeEggg keyType) {
        if (keyType.getType() == String.class || keyType.getType() == Object.class) {
            return key;
        }
        if (keyType.getType() == Integer.class || keyType.getType() == Integer.TYPE) {
            return Integer.parseInt(key);
        }
        if (keyType.getType() == Long.class || keyType.getType() == Long.TYPE) {
            return Long.parseLong(key);
        }
        if (keyType.getType().isEnum()) {
            ObjectDecoder<?> decoder = this.opts.getDecoder(keyType.getType());
            if (decoder == null) {
                return Enum.valueOf(keyType.getType(), key);
            }
            return decoder.decode(new DecodeContext<Object>(this.opts, null, null, keyType), new ONode(this.opts, key));
        }
        throw new CodecException("Unsupported map key type: " + keyType.getType());
    }

    private Object[] getConstrArgs(ConstrEggg constrEggg, ONode node) throws Throwable {
        Object[] argsV = new Object[constrEggg.getParamCount()];
        for (int j = 0; j < argsV.length; ++j) {
            ParamEggg p = constrEggg.getParamEgggAt(j);
            if (node.hasKey(p.getAlias())) {
                Object val;
                ONodeAttrHolder attr = (ONodeAttrHolder)p.getDigest();
                argsV[j] = val = this.decodeValueFromNode(node.get(p.getAlias()), p.getTypeEggg(), null, attr);
                continue;
            }
            argsV[j] = null;
        }
        return argsV;
    }

    private TypeEggg confirmNodeType(ONode oRef, TypeEggg def) {
        TypeEggg type0 = this.resolveNodeType(oRef, def);
        if (Throwable.class.isAssignableFrom(type0.getType())) {
            return type0;
        }
        if (def.getType() != Object.class && !def.isInterface() && !def.isAbstract()) {
            return def;
        }
        return type0;
    }

    private TypeEggg resolveNodeType(ONode oRef, TypeEggg def) {
        if (oRef.isObject()) {
            String typeStr = null;
            if (this.isReadClassName(oRef)) {
                ONode n1 = oRef.getObject().get(this.opts.getTypePropertyName());
                if (n1 != null) {
                    typeStr = n1.getString();
                }
                if (Asserts.isNotEmpty(typeStr)) {
                    if (typeStr.startsWith("sun.") || typeStr.startsWith("com.sun.") || typeStr.startsWith("javax.") || typeStr.startsWith("jdk.")) {
                        throw new CodecException("Unsupported type, class: " + typeStr);
                    }
                    Class<?> clz = this.opts.loadClass(typeStr);
                    if (clz == null) {
                        throw new CodecException("Unsupported type, class: " + typeStr);
                    }
                    return EgggUtil.getTypeEggg(clz);
                }
            }
        }
        if (def.getType() == Object.class) {
            if (oRef.isObject()) {
                return EgggUtil.getTypeEggg(LinkedHashMap.class);
            }
            if (oRef.isArray()) {
                return EgggUtil.getTypeEggg(ArrayList.class);
            }
        }
        return def;
    }

    private boolean isReadClassName(ONode node) {
        if (!this.opts.hasFeature(Feature.Read_AutoType)) {
            return false;
        }
        return node.isObject();
    }
}

