/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.validate.impl;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import org.noear.snack4.ONode;
import org.noear.snack4.jsonschema.JsonSchemaException;
import org.noear.snack4.jsonschema.validate.PathTracker;
import org.noear.snack4.jsonschema.validate.ValidationRule;

public class TypeRule
implements ValidationRule {
    private final Set<String> allowedTypes = new HashSet<String>();

    public TypeRule(ONode typeNode) {
        if (typeNode.isString()) {
            String typeStr = typeNode.getString();
            this.allowedTypes.add(typeStr);
        } else if (typeNode.isArray()) {
            for (ONode t : typeNode.getArray()) {
                this.allowedTypes.add(t.getString());
            }
        }
        if (this.allowedTypes.contains("number")) {
            this.allowedTypes.add("integer");
        }
    }

    @Override
    public void validate(ONode data, PathTracker path) throws JsonSchemaException {
        String actualType = TypeRule.getSchemaTypeName(data);
        if (!this.allowedTypes.contains(actualType)) {
            throw new JsonSchemaException("Type mismatch. Expected: " + this.allowedTypes + ", Actual: " + actualType + " at " + path.currentPath());
        }
    }

    public String toString() {
        return "TypeRule{allowedTypes=" + this.allowedTypes + '}';
    }

    private static String getSchemaTypeName(ONode node) {
        switch (node.type()) {
            case Undefined: {
                return "undefined";
            }
            case Null: {
                return "null";
            }
            case Boolean: {
                return "boolean";
            }
            case Number: {
                if (node.getValue() instanceof Float || node.getValue() instanceof Double || node.getValue() instanceof BigDecimal) {
                    return "number";
                }
                return "integer";
            }
            case String: {
                return "string";
            }
            case Date: {
                return "date";
            }
            case Array: {
                return "array";
            }
            case Object: {
                return "object";
            }
        }
        return "unknown";
    }
}

