/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.validate.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.noear.snack4.ONode;
import org.noear.snack4.jsonschema.JsonSchemaException;
import org.noear.snack4.jsonschema.validate.PathTracker;
import org.noear.snack4.jsonschema.validate.ValidationRule;

public class RequiredRule
implements ValidationRule {
    private final List<String> requiredFields;

    public RequiredRule(ONode requiredNode) {
        this.requiredFields = requiredNode.getArray().stream().map(ONode::getString).collect(Collectors.toList());
    }

    @Override
    public void validate(ONode data, PathTracker path) throws JsonSchemaException {
        if (!data.isObject()) {
            return;
        }
        String currentPath = path.currentPath();
        for (String field : this.requiredFields) {
            if (data.getObject().containsKey(field)) continue;
            throw new JsonSchemaException("Missing required field: " + field + " at " + currentPath);
        }
    }
}

