/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.generate;

import java.net.URI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.eggg.TypeEggg;
import org.noear.snack4.jsonschema.generate.SchemaMapper;
import org.noear.snack4.jsonschema.generate.SchemaPatternMapper;
import org.noear.snack4.jsonschema.generate.impl.BooleanMapper;
import org.noear.snack4.jsonschema.generate.impl.ByteArrayMapper;
import org.noear.snack4.jsonschema.generate.impl.ByteMapper;
import org.noear.snack4.jsonschema.generate.impl.CharMapper;
import org.noear.snack4.jsonschema.generate.impl.LocalDateMapper;
import org.noear.snack4.jsonschema.generate.impl.LocalDateTimeMapper;
import org.noear.snack4.jsonschema.generate.impl.LocalTimeMapper;
import org.noear.snack4.jsonschema.generate.impl.StringMapper;
import org.noear.snack4.jsonschema.generate.impl.URIMapper;
import org.noear.snack4.jsonschema.generate.impl._DatePatternMapper;
import org.noear.snack4.jsonschema.generate.impl._EnumPatternMapper;
import org.noear.snack4.jsonschema.generate.impl._NumberPatternMapper;

public class MapperLib {
    private static final MapperLib DEFAULT = new MapperLib(null).loadDefault();
    private final List<SchemaPatternMapper> TYPE_PATTERN_GENERATORS = new ArrayList<SchemaPatternMapper>();
    private final Map<Class<?>, SchemaMapper> TYPE_GENERATOR_MAP = new ConcurrentHashMap();
    private final MapperLib parent;

    public MapperLib(MapperLib parent) {
        this.parent = parent;
    }

    public static MapperLib newInstance() {
        return new MapperLib(DEFAULT);
    }

    public <T> void addMapper(SchemaPatternMapper<T> generator) {
        this.TYPE_PATTERN_GENERATORS.add(generator);
    }

    public <T> void addMapper(Class<T> type, SchemaMapper<T> generator) {
        if (generator instanceof SchemaPatternMapper) {
            this.addMapper((SchemaPatternMapper)generator);
        }
        this.TYPE_GENERATOR_MAP.put(type, generator);
    }

    public SchemaMapper getMapper(TypeEggg typeEggg) {
        SchemaMapper tmp = this.TYPE_GENERATOR_MAP.get(typeEggg.getType());
        if (tmp == null) {
            for (SchemaPatternMapper b1 : this.TYPE_PATTERN_GENERATORS) {
                if (!b1.supports(typeEggg)) continue;
                return b1;
            }
            if (this.parent != null) {
                return this.parent.getMapper(typeEggg);
            }
        }
        return tmp;
    }

    private MapperLib loadDefault() {
        this.TYPE_PATTERN_GENERATORS.add(new _DatePatternMapper());
        this.TYPE_PATTERN_GENERATORS.add(new _EnumPatternMapper());
        this.TYPE_PATTERN_GENERATORS.add(new _NumberPatternMapper());
        this.TYPE_GENERATOR_MAP.put(Boolean.class, BooleanMapper.getInstance());
        this.TYPE_GENERATOR_MAP.put(Boolean.TYPE, BooleanMapper.getInstance());
        this.TYPE_GENERATOR_MAP.put(Character.class, CharMapper.getInstance());
        this.TYPE_GENERATOR_MAP.put(Character.TYPE, CharMapper.getInstance());
        this.TYPE_GENERATOR_MAP.put(Byte.class, ByteMapper.getInstance());
        this.TYPE_GENERATOR_MAP.put(Byte.TYPE, ByteMapper.getInstance());
        this.TYPE_GENERATOR_MAP.put(Byte[].class, ByteArrayMapper.getInstance());
        this.TYPE_GENERATOR_MAP.put(byte[].class, ByteArrayMapper.getInstance());
        this.TYPE_GENERATOR_MAP.put(String.class, new StringMapper());
        this.TYPE_GENERATOR_MAP.put(URI.class, new URIMapper());
        this.TYPE_GENERATOR_MAP.put(LocalDate.class, new LocalDateMapper());
        this.TYPE_GENERATOR_MAP.put(LocalTime.class, new LocalTimeMapper());
        this.TYPE_GENERATOR_MAP.put(LocalDateTime.class, new LocalDateTimeMapper());
        return this;
    }
}

