/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack4.jsonschema.generate;

import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.PropertyEggg;
import org.noear.eggg.TypeEggg;
import org.noear.snack4.ONode;
import org.noear.snack4.annotation.ONodeAttrHolder;
import org.noear.snack4.codec.util.EgggUtil;
import org.noear.snack4.jsonschema.JsonSchema;
import org.noear.snack4.jsonschema.JsonSchemaException;
import org.noear.snack4.jsonschema.generate.SchemaMapper;
import org.noear.snack4.util.Asserts;

public class JsonSchemaGenerator {
    private final JsonSchema config;
    private final TypeEggg source0;
    private final Map<Object, Object> visited;
    private final Map<String, ONode> definitions;
    private int definitionCounter = 0;

    public JsonSchemaGenerator(Type type) {
        this(type, JsonSchema.DEFAULT);
    }

    public JsonSchemaGenerator(Type type, JsonSchema config) {
        Objects.requireNonNull(type, "Type cannot be null");
        Objects.requireNonNull(config, "Config cannot be null");
        if (type == Void.TYPE || type == Void.class) {
            throw new JsonSchemaException("Void type is not supported for JSON schema generation");
        }
        this.config = config;
        this.source0 = EgggUtil.getTypeEggg((Type)type);
        this.visited = new IdentityHashMap<Object, Object>();
        this.definitions = new LinkedHashMap<String, ONode>();
    }

    public JsonSchemaGenerator(TypeEggg typeEggg) {
        this(typeEggg, JsonSchema.DEFAULT);
    }

    public JsonSchemaGenerator(TypeEggg typeEggg, JsonSchema config) {
        Objects.requireNonNull(typeEggg, "TypeEggg cannot be null");
        Objects.requireNonNull(config, "Config cannot be null");
        if (typeEggg.getType() == Void.TYPE || typeEggg.getType() == Void.class) {
            throw new JsonSchemaException("Void type is not supported for JSON schema generation");
        }
        this.config = config;
        this.source0 = typeEggg;
        this.visited = new IdentityHashMap<Object, Object>();
        this.definitions = new LinkedHashMap<String, ONode>();
    }

    public ONode generate() {
        try {
            return this.doGenerate();
        }
        catch (JsonSchemaException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JsonSchemaException("Failed to generate JSON schema for type: " + this.source0.getType().getName(), e);
        }
    }

    private ONode newNode() {
        return new ONode();
    }

    private ONode doGenerate() throws Throwable {
        ONode oNode;
        ONode target = this.newNode();
        if (this.config.isPrintVersion()) {
            target.set("$schema", (Object)this.config.getVersion().getIdentifier());
        }
        if (this.config.isEnableDefinitions()) {
            String definitionsKey = this.getDefinitionsKey();
            target.getOrNew(definitionsKey);
        }
        if ((oNode = this.generateValueToNode(this.source0, target)) != null && this.config.isEnableDefinitions() && !this.definitions.isEmpty()) {
            String definitionsKey = this.getDefinitionsKey();
            oNode.getOrNew(definitionsKey).setAll(this.definitions);
        }
        return oNode;
    }

    private String getDefinitionsKey() {
        switch (this.config.getVersion()) {
            case DRAFT_7: {
                return "definitions";
            }
        }
        return "$defs";
    }

    private boolean shouldCreateDefinition(TypeEggg typeEggg) {
        if (this.source0.equals((Object)typeEggg)) {
            return false;
        }
        Class clazz = typeEggg.getType();
        return !clazz.isPrimitive() && !typeEggg.isJdkType();
    }

    private String getDefinitionName(TypeEggg typeEggg) {
        Class clazz = typeEggg.getType();
        String simpleName = clazz.getSimpleName();
        if (simpleName.isEmpty()) {
            return "Definition_" + this.definitionCounter++;
        }
        return simpleName;
    }

    private ONode createReference(String definitionName) {
        ONode refNode = this.newNode().asObject();
        refNode.set("$ref", (Object)("#/" + this.getDefinitionsKey() + "/" + definitionName));
        return refNode;
    }

    private ONode generateValueToNode(TypeEggg typeEggg, ONode target) throws Throwable {
        SchemaMapper generator = this.config.getMapper(typeEggg);
        if (generator != null) {
            return generator.mapSchema(typeEggg, target);
        }
        if (typeEggg.isCollection()) {
            return this.generateCollectionToNode(typeEggg, target);
        }
        if (typeEggg.isMap()) {
            return this.generateMapToNode(typeEggg, target);
        }
        if (typeEggg.isArray()) {
            return this.generateArrayToNode(typeEggg, target);
        }
        return this.generateBeanToNode(typeEggg, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ONode generateBeanToNode(TypeEggg typeEggg, ONode target) throws Throwable {
        if (this.visited.containsKey(typeEggg)) {
            return this.handleCircularReference(typeEggg);
        }
        this.visited.put(typeEggg, null);
        target.set("type", (Object)"object");
        String definitionName = null;
        if (this.config.isEnableDefinitions() && this.shouldCreateDefinition(typeEggg)) {
            definitionName = this.getDefinitionName(typeEggg);
            this.definitions.put(definitionName, target);
        }
        try {
            ONode oNode;
            ONode oProperties = target.getOrNew("properties").asObject(TreeMap::new);
            ONode oRequired = target.getOrNew("required").asArray();
            ClassEggg classEggg = typeEggg.getClassEggg();
            for (PropertyEggg pw : classEggg.getPropertyEgggs()) {
                ONode propertyNode;
                Object property = pw.getGetterEggg() != null ? pw.getGetterEggg() : pw.getFieldEggg();
                if (property == null) continue;
                ONodeAttrHolder attr = (ONodeAttrHolder)property.getDigest();
                if (property.isTransient() || !attr.isEncode() || (propertyNode = this.generateValueToNode(property.getTypeEggg(), this.newNode())) == null) continue;
                if (Asserts.isNotEmpty((String)attr.getDescription())) {
                    propertyNode.set("description", (Object)attr.getDescription());
                }
                if (Asserts.isNotEmpty((String)attr.getTitle())) {
                    propertyNode.set("title", (Object)attr.getTitle());
                }
                if (attr.isFlat()) {
                    if (!propertyNode.isObject()) continue;
                    oProperties.setAll(propertyNode.getObject());
                    if (!attr.isRequired()) continue;
                    oRequired.addAll(propertyNode.getObject().keySet());
                    continue;
                }
                oProperties.set(property.getAlias(), (Object)propertyNode);
                if (!attr.isRequired()) continue;
                oRequired.add((Object)property.getAlias());
            }
            if (this.config.isEnableDefinitions() && definitionName != null) {
                oNode = this.createReference(definitionName);
                return oNode;
            }
            oNode = target;
            return oNode;
        }
        finally {
            this.visited.remove(typeEggg);
        }
    }

    private ONode handleCircularReference(TypeEggg typeEggg) {
        String definitionName;
        if (this.config.isEnableDefinitions() && this.definitions.containsKey(definitionName = this.getDefinitionName(typeEggg))) {
            return this.createReference(definitionName);
        }
        return this.newNode().asObject().set("type", (Object)"object").set("description", (Object)("Circular reference detected for: " + typeEggg.getType().getSimpleName()));
    }

    private ONode generateArrayToNode(TypeEggg typeEggg, ONode target) throws Throwable {
        target.set("type", (Object)"array");
        ONode itemsType = this.generateValueToNode(EgggUtil.getTypeEggg(typeEggg.getType().getComponentType()), this.newNode());
        target.set("items", (Object)itemsType);
        return target;
    }

    private ONode generateCollectionToNode(TypeEggg typeEggg, ONode target) throws Throwable {
        target.set("type", (Object)"array");
        if (typeEggg.isParameterizedType()) {
            ONode itemsType = this.generateValueToNode(EgggUtil.getTypeEggg((Type)typeEggg.getActualTypeArguments()[0]), this.newNode());
            target.set("items", (Object)itemsType);
        }
        return target;
    }

    private ONode generateMapToNode(TypeEggg typeEggg, ONode target) throws Throwable {
        target.set("type", (Object)"object");
        if (typeEggg.isParameterizedType() && typeEggg.getActualTypeArguments().length > 1) {
            ONode keySchema;
            TypeEggg keyEggg = EgggUtil.getTypeEggg((Type)typeEggg.getActualTypeArguments()[0]);
            TypeEggg valueEggg = EgggUtil.getTypeEggg((Type)typeEggg.getActualTypeArguments()[1]);
            if (keyEggg.getType() != Object.class && keyEggg.getType() != String.class && (keySchema = this.generateValueToNode(keyEggg, this.newNode())) != null) {
                ONode propertyNamesSchema = this.newNode().asObject();
                propertyNamesSchema.set("type", (Object)"string");
                ONode propertyNamesInnerSchema = this.generateValueToNode(keyEggg, this.newNode());
                target.set("propertyNames", (Object)propertyNamesInnerSchema);
            }
            if (valueEggg.getType() != Object.class) {
                ONode valueSchema = this.generateValueToNode(valueEggg, this.newNode());
                target.set("additionalProperties", (Object)valueSchema);
            } else {
                target.set("additionalProperties", (Object)true);
            }
        } else {
            target.set("additionalProperties", (Object)true);
        }
        return target;
    }
}

