/*
 * Decompiled with CFR 0.152.
 */
package org.noear.eggg;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.noear.eggg.AnnotatedEggg;
import org.noear.eggg.ConstrEggg;
import org.noear.eggg.Eggg;
import org.noear.eggg.FieldEggg;
import org.noear.eggg.JavaUtil;
import org.noear.eggg.MethodEggg;
import org.noear.eggg.PropertyEggg;
import org.noear.eggg.PropertyMethodEggg;
import org.noear.eggg.TypeEggg;

public class ClassEggg
implements AnnotatedEggg {
    private final TypeEggg typeEggg;
    private final Object digest;
    private ConstrEggg creator;
    private final List<ConstrEggg> constrEgggs;
    private final Map<String, FieldEggg> allFieldEgggsForName;
    private final Map<String, FieldEggg> allFieldEgggsForAlias;
    private final Map<Method, MethodEggg> ownMethodEgggsMap;
    private final List<MethodEggg> ownMethodEgggs;
    private final List<MethodEggg> publicMethodEgggs;
    private final List<MethodEggg> declaredMethodEgggs;
    private final Map<String, PropertyEggg> propertyEgggsForName = new LinkedHashMap<String, PropertyEggg>();
    private final Map<String, PropertyEggg> propertyEgggsForAlias;
    private boolean likeRecordClass = true;
    private final boolean realRecordClass;
    private final Eggg eggg;
    private Annotation[] annotations;

    public ClassEggg(Eggg eggg, TypeEggg typeEggg) {
        Objects.requireNonNull(eggg, "eggg");
        Objects.requireNonNull(typeEggg, "typeEggg");
        this.eggg = eggg;
        this.typeEggg = typeEggg;
        this.realRecordClass = JavaUtil.isRecordClass(typeEggg.getType());
        this.allFieldEgggsForName = new LinkedHashMap<String, FieldEggg>();
        this.loadFields();
        this.likeRecordClass = this.likeRecordClass && this.allFieldEgggsForName.size() > 0;
        this.allFieldEgggsForAlias = new LinkedHashMap<String, FieldEggg>(this.allFieldEgggsForName.size());
        for (Map.Entry<String, FieldEggg> entry : this.allFieldEgggsForName.entrySet()) {
            this.allFieldEgggsForAlias.put(entry.getValue().getAlias(), entry.getValue());
        }
        Method[] declaredMethods = eggg.getDeclaredMethods(typeEggg.getType());
        Method[] methods = eggg.getMethods(typeEggg.getType());
        this.ownMethodEgggs = new ArrayList<MethodEggg>(declaredMethods.length + methods.length);
        this.ownMethodEgggsMap = new HashMap<Method, MethodEggg>(declaredMethods.length + methods.length);
        this.publicMethodEgggs = methods.length == 0 ? Collections.emptyList() : new ArrayList<MethodEggg>(methods.length);
        this.declaredMethodEgggs = declaredMethods.length == 0 ? Collections.emptyList() : new ArrayList<MethodEggg>(declaredMethods.length);
        this.loadMethods(declaredMethods, methods);
        this.propertyEgggsForAlias = new LinkedHashMap<String, PropertyEggg>(this.propertyEgggsForName.size());
        for (Map.Entry<String, PropertyEggg> entry : this.propertyEgggsForName.entrySet()) {
            this.propertyEgggsForAlias.put(entry.getValue().getAlias(), entry.getValue());
        }
        Constructor[] declaredConstructors = typeEggg.getType().getDeclaredConstructors();
        this.constrEgggs = new ArrayList<ConstrEggg>(declaredConstructors.length);
        this.loadConstr(declaredConstructors);
        this.digest = eggg.findDigest(this, this, null);
    }

    public boolean isRealRecordClass() {
        return this.realRecordClass;
    }

    public boolean isLikeRecordClass() {
        return this.likeRecordClass;
    }

    public TypeEggg getTypeEggg() {
        return this.typeEggg;
    }

    public Class<?> getType() {
        return this.typeEggg.getType();
    }

    public Type getGenericType() {
        return this.typeEggg.getGenericType();
    }

    @Override
    public AnnotatedElement getElement() {
        return this.typeEggg.getType();
    }

    @Override
    public <T> T getDigest() {
        return (T)this.digest;
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.typeEggg.getType().getAnnotations();
        }
        return this.annotations;
    }

    public ConstrEggg getCreator() {
        return this.creator;
    }

    public ConstrEggg findConstrEggg(Class<?> ... parameterTypes) throws NoSuchMethodException {
        ConstrEggg c1 = this.findConstrEgggOrNull(parameterTypes);
        if (c1 == null) {
            throw new NoSuchMethodException(this.typeEggg.getType().getName() + ".()" + ClassEggg.argumentTypesToString(parameterTypes));
        }
        return c1;
    }

    public ConstrEggg findConstrEgggOrNull(Class<?> ... parameterTypes) throws NoSuchMethodException {
        for (ConstrEggg c1 : this.constrEgggs) {
            if (c1.getParamCount() != parameterTypes.length) continue;
            if (parameterTypes.length == 0) {
                return c1;
            }
            if (!Arrays.equals(c1.getConstr().getParameterTypes(), parameterTypes)) continue;
            return c1;
        }
        return null;
    }

    public Collection<MethodEggg> getPublicMethodEgggs() {
        return this.publicMethodEgggs;
    }

    public Collection<MethodEggg> getDeclaredMethodEgggs() {
        return this.declaredMethodEgggs;
    }

    public MethodEggg findMethodEggg(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        MethodEggg m1 = this.findMethodEgggOrNull(name, parameterTypes);
        if (m1 == null) {
            throw new NoSuchMethodException(this.typeEggg.getType().getName() + "." + name + ClassEggg.argumentTypesToString(parameterTypes));
        }
        return m1;
    }

    public MethodEggg findMethodEgggOrNull(String name, Class<?> ... parameterTypes) {
        for (MethodEggg m1 : this.declaredMethodEgggs) {
            if (m1.getParamCount() != parameterTypes.length || !m1.getName().equals(name)) continue;
            if (parameterTypes.length == 0) {
                return m1;
            }
            if (!Arrays.equals(m1.getMethod().getParameterTypes(), parameterTypes)) continue;
            return m1;
        }
        for (MethodEggg m1 : this.publicMethodEgggs) {
            if (m1.getParamCount() != parameterTypes.length || !m1.getName().equals(name)) continue;
            if (parameterTypes.length == 0) {
                return m1;
            }
            if (!Arrays.equals(m1.getMethod().getParameterTypes(), parameterTypes)) continue;
            return m1;
        }
        return null;
    }

    public MethodEggg findMethodEgggOrNew(Method method) {
        return this.ownMethodEgggsMap.computeIfAbsent(method, k -> this.eggg.newMethodEggg(this, (Method)k));
    }

    public Collection<MethodEggg> getOwnMethodEgggs() {
        return this.ownMethodEgggs;
    }

    public Collection<FieldEggg> getAllFieldEgggs() {
        return this.allFieldEgggsForName.values();
    }

    public FieldEggg getFieldEgggByName(String name) {
        return this.allFieldEgggsForName.get(name);
    }

    public FieldEggg getFieldEgggByAlias(String alias) {
        return this.allFieldEgggsForAlias.get(alias);
    }

    public Collection<PropertyEggg> getPropertyEgggs() {
        return this.propertyEgggsForName.values();
    }

    public PropertyEggg getPropertyEgggByName(String name) {
        return this.propertyEgggsForName.get(name);
    }

    public PropertyEggg getPropertyEgggByAlias(String alias) {
        return this.propertyEgggsForAlias.get(alias);
    }

    protected void loadConstr(Constructor[] declaredConstructors) {
        for (Constructor c1 : declaredConstructors) {
            this.constrEgggs.add(new ConstrEggg(this.eggg, this, c1, this.eggg.findCreator(c1)));
        }
        if (this.typeEggg.getType().isEnum()) {
            for (MethodEggg me : this.declaredMethodEgggs) {
                boolean isCreator;
                if (!me.isStatic() || !(isCreator = this.eggg.findCreator(me.getMethod()))) continue;
                this.creator = this.eggg.newConstrEggg(this, me.getMethod(), isCreator);
                return;
            }
        }
        for (ConstrEggg c1 : this.constrEgggs) {
            if (c1.isCreator()) {
                this.creator = c1;
                return;
            }
            if (this.creator == null) {
                this.creator = c1;
                continue;
            }
            if (this.creator.getParamCount() <= c1.getParamCount()) continue;
            this.creator = c1;
        }
    }

    protected void loadFields() {
        for (Class<?> clz = this.typeEggg.getType(); clz != null; clz = clz.getSuperclass()) {
            for (Field f1 : this.eggg.getDeclaredFields(clz)) {
                this.allFieldEgggsForName.computeIfAbsent(f1.getName(), kn -> {
                    FieldEggg fe = this.eggg.newFieldEggg(this, f1);
                    if (!fe.isStatic()) {
                        this.likeRecordClass = this.likeRecordClass && fe.isFinal();
                        this.propertyEgggsForName.computeIfAbsent(fe.getName(), k -> new PropertyEggg((String)k)).setFieldEggg(fe);
                    }
                    return fe;
                });
            }
        }
    }

    protected void loadMethods(Method[] declaredMethods, Method[] methods) {
        MethodEggg me;
        for (Method m1 : declaredMethods) {
            if (m1.getDeclaringClass() == Object.class || m1.isBridge()) continue;
            me = this.eggg.newMethodEggg(this, m1);
            this.declaredMethodEgggs.add(me);
            if (me.isPublic()) continue;
            this.ownMethodEgggs.add(me);
            this.ownMethodEgggsMap.put(m1, me);
        }
        for (Method m1 : methods) {
            String m1N;
            if (m1.getDeclaringClass() == Object.class) continue;
            if (m1.isBridge()) {
                m1 = this.findActualMethod(this.typeEggg.getType().getSuperclass(), m1);
            }
            if (m1 == null) continue;
            me = this.eggg.newMethodEggg(this, m1);
            this.publicMethodEgggs.add(me);
            this.ownMethodEgggs.add(me);
            this.ownMethodEgggsMap.put(m1, me);
            if (me.isStatic() || !me.isPublic() || (m1N = m1.getName()).length() <= 2) continue;
            if (m1.getReturnType() == Void.TYPE && m1.getParameterCount() == 1) {
                if (m1N.length() <= 3 || !m1N.startsWith("set")) continue;
                PropertyMethodEggg sw = this.eggg.newPropertyMethodEggg(this, me);
                this.propertyEgggsForName.computeIfAbsent(sw.getName(), k -> new PropertyEggg((String)k)).setSetterEggg(sw);
                continue;
            }
            if (m1.getReturnType() == Void.TYPE || m1.getParameterCount() != 0 || (m1N.length() <= 3 || !m1N.startsWith("get")) && (m1N.length() <= 2 || !m1N.startsWith("is"))) continue;
            PropertyMethodEggg gw = this.eggg.newPropertyMethodEggg(this, me);
            this.propertyEgggsForName.computeIfAbsent(gw.getName(), k -> new PropertyEggg((String)k)).setGetterEggg(gw);
        }
    }

    private Method findActualMethod(Class<?> clz, Method m1) {
        try {
            m1 = clz.getMethod(m1.getName(), m1.getParameterTypes());
            if (m1 != null) {
                if (m1.isBridge()) {
                    return this.findActualMethod(clz.getSuperclass(), m1);
                }
                return m1;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public int hashCode() {
        return this.typeEggg.hashCode();
    }

    public String toString() {
        return this.typeEggg.toString();
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }
}

