/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;

public abstract class NodeProvider
implements Lookup.Provider {
    private final TreeSet<Node> nodeSet;
    private final ChangeSupport changeSupport;
    private final Lookup lookup;
    protected boolean initialized = false;
    private boolean isProxied = false;

    public NodeProvider(Lookup lookup) {
        this.lookup = lookup;
        this.changeSupport = new ChangeSupport((Object)this);
        this.nodeSet = new TreeSet<Node>(new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                return n1.getDisplayName().compareTo(n2.getDisplayName());
            }
        });
    }

    public NodeProvider(Lookup lookup, Comparator<Node> comparator) {
        this.lookup = lookup;
        this.changeSupport = new ChangeSupport((Object)this);
        this.nodeSet = new TreeSet<Node>(comparator);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public synchronized Collection<Node> getNodes() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        if (this.isProxied) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node child : this.nodeSet) {
                if (!(child instanceof BaseNode)) continue;
                BaseNode node = (BaseNode)child;
                Collection<? extends Node> list = node.getNodeRegistry().getNodes();
                for (Node node2 : list) {
                    nodes.add(node2);
                }
            }
            return Collections.unmodifiableCollection(nodes);
        }
        return Collections.unmodifiableCollection(this.nodeSet);
    }

    public synchronized void refresh() {
        this.initialized = false;
        TreeSet nodes = (TreeSet)this.nodeSet.clone();
        for (Node child : nodes) {
            if (!(child instanceof BaseNode)) continue;
            ((BaseNode)child).refresh();
        }
    }

    protected abstract void initialize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Node> getNodes(Object dataObject) {
        ArrayList<Node> results = new ArrayList<Node>();
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            for (Node child : this.nodeSet) {
                Object obj = child.getLookup().lookup(dataObject.getClass());
                if (obj == null || obj.hashCode() != dataObject.hashCode() || !obj.equals(dataObject)) continue;
                results.add(child);
            }
        }
        return Collections.unmodifiableCollection(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProxyNodes(Collection<Node> newList) {
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            this.isProxied = true;
            this.nodeSet.clear();
            this.nodeSet.addAll(newList);
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodes(Collection<Node> newList) {
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            this.isProxied = false;
            this.nodeSet.clear();
            this.nodeSet.addAll(newList);
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(Node node) {
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            this.nodeSet.add(node);
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node node) {
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            this.nodeSet.remove(node);
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNodes() {
        TreeSet<Node> treeSet = this.nodeSet;
        synchronized (treeSet) {
            this.nodeSet.clear();
        }
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }
}

