/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.function.Consumer;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class RelationshipReference
extends VirtualRelationshipValue
implements RelationshipVisitor {
    static final long NO_NODE = -1L;
    static final int NO_TYPE = -1;
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipReference.class);
    private final long id;
    private long startNode;
    private long endNode;
    private int type;

    RelationshipReference(long id) {
        this(id, -1L, -1L, -1);
    }

    RelationshipReference(long id, long startNode, long endNode) {
        this(id, startNode, endNode, -1);
    }

    RelationshipReference(long id, long startNode, long endNode, int type) {
        this.id = id;
        this.startNode = startNode;
        this.endNode = endNode;
        this.type = type;
    }

    @Override
    public long startNodeId(Consumer<RelationshipVisitor> consumer) {
        if (this.startNode == -1L) {
            consumer.accept(this);
        }
        return this.startNode;
    }

    @Override
    public long endNodeId(Consumer<RelationshipVisitor> consumer) {
        if (this.endNode == -1L) {
            consumer.accept(this);
        }
        return this.endNode;
    }

    @Override
    public int relationshipTypeId(Consumer<RelationshipVisitor> consumer) {
        if (this.type == -1) {
            consumer.accept(this);
        }
        return this.type;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.writeRelationshipReference(this.id);
    }

    @Override
    public String getTypeName() {
        return "RelationshipReference";
    }

    public String toString() {
        return String.format("-[%d]-", this.id);
    }

    @Override
    public long id() {
        return this.id;
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE;
    }

    @Override
    public void visit(long startNode, long endNode, int type) {
        this.startNode = startNode;
        this.endNode = endNode;
        this.type = type;
    }
}

