/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.NumberType;

public abstract class NonPrimitiveArray<T extends Comparable<? super T>>
extends ArrayValue {
    protected abstract T[] value();

    @Override
    public final boolean equals(boolean[] x) {
        return false;
    }

    @Override
    public final boolean equals(char[] x) {
        return false;
    }

    @Override
    public final boolean equals(String[] x) {
        return false;
    }

    @Override
    public final boolean equals(byte[] x) {
        return false;
    }

    @Override
    public final boolean equals(short[] x) {
        return false;
    }

    @Override
    public final boolean equals(int[] x) {
        return false;
    }

    @Override
    public final boolean equals(long[] x) {
        return false;
    }

    @Override
    public final boolean equals(float[] x) {
        return false;
    }

    @Override
    public final boolean equals(double[] x) {
        return false;
    }

    @Override
    public final NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    protected final int compareToNonPrimitiveArray(NonPrimitiveArray<T> other) {
        int x = 0;
        int length = Math.min(this.length(), other.length());
        for (int i = 0; x == 0 && i < length; ++i) {
            x = this.value()[i].compareTo(other.value()[i]);
        }
        if (x == 0) {
            x = this.length() - other.length();
        }
        return x;
    }

    @Override
    public final int computeHash() {
        return Arrays.hashCode(this.value());
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, (long)this.length());
        for (Comparable obj : this.value()) {
            hash = hashFunction.update(hash, (long)obj.hashCode());
        }
        return hash;
    }

    @Override
    public final int length() {
        return this.value().length;
    }

    public final T[] asObjectCopy() {
        return (Comparable[])this.value().clone();
    }

    @Deprecated
    public final T[] asObject() {
        return this.value();
    }

    @Override
    public final String prettyPrint() {
        return Arrays.toString(this.value());
    }

    public final String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.value());
    }
}

