/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.string.HexString;

class StoreIdDecodeUtils {
    private static final String DEFAULT_ALGORITHM = "SHA-256";

    private StoreIdDecodeUtils() {
    }

    static String decodeId(StoreIdProvider storeIdProvider) throws NoSuchAlgorithmException {
        Optional externalStoreId = storeIdProvider.getExternalStoreId();
        StoreId storeId = storeIdProvider.getStoreId();
        String storeIdString = externalStoreId.isPresent() ? ((ExternalStoreId)externalStoreId.get()).toString() : String.format("%d%d%d", storeId.getCreationTime(), storeId.getRandomId(), storeId.getStoreVersion());
        MessageDigest messageDigest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
        messageDigest.update(storeIdString.getBytes());
        return HexString.encodeHexString((byte[])messageDigest.digest());
    }
}

