/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.function.IntFunction;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.SchemaDescriptor;

public class ConstraintsProcedureUtil {
    static String prettyPrint(ConstraintDescriptor constraintDescriptor, TokenNameLookup tokenNameLookup) {
        SchemaDescriptor schema = constraintDescriptor.schema();
        int[] entityTokenIds = schema.getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw new IllegalArgumentException("Cannot pretty-print multi-token constraints: " + constraintDescriptor.userDescription(tokenNameLookup));
        }
        String entityTypeName = schema.entityType() == EntityType.NODE ? tokenNameLookup.labelGetName(entityTokenIds[0]) : tokenNameLookup.relationshipTypeGetName(entityTokenIds[0]);
        entityTypeName = ConstraintsProcedureUtil.escapeLabelOrRelTyp(entityTypeName);
        String entityName = entityTypeName.toLowerCase();
        String properties = ConstraintsProcedureUtil.formatProperties(schema.getPropertyIds(), tokenNameLookup, entityName);
        ConstraintType type = constraintDescriptor.type();
        switch (type) {
            case EXISTS: {
                switch (schema.entityType()) {
                    case NODE: {
                        return "CONSTRAINT ON ( " + entityName + ":" + entityTypeName + " ) ASSERT exists" + properties;
                    }
                    case RELATIONSHIP: {
                        return "CONSTRAINT ON ()-[ " + entityName + ":" + entityTypeName + " ]-() ASSERT exists" + properties;
                    }
                }
                throw new IllegalStateException("Unknown schema entity type: " + schema.entityType() + ".");
            }
            case UNIQUE: {
                return "CONSTRAINT ON ( " + entityName + ":" + entityTypeName + " ) ASSERT " + properties + " IS UNIQUE";
            }
            case UNIQUE_EXISTS: {
                return "CONSTRAINT ON ( " + entityName + ":" + entityTypeName + " ) ASSERT " + properties + " IS NODE KEY";
            }
        }
        throw new IllegalStateException("Unknown constraint type: " + type + ".");
    }

    private static String escapeLabelOrRelTyp(String name) {
        if (name.contains(":")) {
            return "`" + name + "`";
        }
        return name;
    }

    private static String formatProperties(int[] propertyIds, TokenNameLookup tokenNameLookup, String nodeName) {
        return ConstraintsProcedureUtil.niceProperties(tokenNameLookup, propertyIds, nodeName + ".");
    }

    private static String niceProperties(TokenNameLookup lookup, int[] propertyIds, String prefix) {
        StringBuilder out = new StringBuilder();
        out.append('(');
        ConstraintsProcedureUtil.format(out, prefix, ", ", arg_0 -> ((TokenNameLookup)lookup).propertyKeyGetName(arg_0), propertyIds);
        out.append(')');
        return out.toString();
    }

    private static void format(StringBuilder out, String prefix, String separator, IntFunction<String> lookup, int[] ids) {
        for (int id : ids) {
            String name = lookup.apply(id);
            out.append(prefix);
            if (name.contains(":")) {
                out.append('`').append(name).append('`');
            } else {
                out.append(name);
            }
            out.append(separator);
        }
        if (ids.length > 0) {
            out.setLength(out.length() - separator.length());
        }
    }
}

