/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.transaction;

import java.lang.reflect.Field;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedTransaction
extends AbstractTransaction {
    private final Transaction nativeTransaction;
    private final Logger LOGGER = LoggerFactory.getLogger(EmbeddedTransaction.class);

    public EmbeddedTransaction(TransactionManager transactionManager, Transaction nativeTransaction, Transaction.Type type) {
        super(transactionManager);
        this.nativeTransaction = nativeTransaction;
        this.type = type;
    }

    public void rollback() {
        try {
            if (this.transactionManager.canRollback()) {
                this.LOGGER.debug("rolling back native transaction: {}", (Object)this.nativeTransaction);
                if (this.transactionIsOpen()) {
                    this.nativeTransaction.failure();
                    this.nativeTransaction.close();
                } else {
                    this.LOGGER.warn("Transaction is already closed");
                }
            }
        }
        catch (Exception e) {
            throw new TransactionException(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            super.rollback();
        }
    }

    public void commit() {
        block6: {
            try {
                if (!this.transactionManager.canCommit()) break block6;
                this.LOGGER.debug("Committing native transaction: {}", (Object)this.nativeTransaction);
                if (this.transactionIsOpen()) {
                    this.nativeTransaction.success();
                    this.nativeTransaction.close();
                    break block6;
                }
                throw new IllegalStateException("This transaction has already been completed.");
            }
            catch (Exception e) {
                throw new TransactionException(e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                super.commit();
            }
        }
    }

    public Transaction getNativeTransaction() {
        return this.nativeTransaction;
    }

    public boolean transactionIsOpen() {
        try {
            Field transactionField = this.nativeTransaction.getClass().getDeclaredField("transaction");
            transactionField.setAccessible(true);
            KernelTransaction kernelTransaction = (KernelTransaction)transactionField.get(this.nativeTransaction);
            return kernelTransaction.isOpen();
        }
        catch (Exception e) {
            return false;
        }
    }
}

