/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.verification;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.neo4j.exceptions.KernelException;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.verification.CompositeDuplicateCheckingCollector;
import org.neo4j.kernel.api.impl.schema.verification.DuplicateCheckStrategy;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

public class DuplicateCheckingCollector
extends SimpleCollector {
    protected final NodePropertyAccessor accessor;
    private final int propertyKeyId;
    protected LeafReader reader;
    DuplicateCheckStrategy duplicateCheckStrategy;

    static DuplicateCheckingCollector forProperties(NodePropertyAccessor accessor, int[] propertyKeyIds) {
        return propertyKeyIds.length == 1 ? new DuplicateCheckingCollector(accessor, propertyKeyIds[0]) : new CompositeDuplicateCheckingCollector(accessor, propertyKeyIds);
    }

    DuplicateCheckingCollector(NodePropertyAccessor accessor, int propertyKeyId) {
        this.accessor = accessor;
        this.propertyKeyId = propertyKeyId;
    }

    public void collect(int doc) throws IOException {
        try {
            this.doCollect(doc);
        }
        catch (IndexEntryConflictException e) {
            throw new IOException(e);
        }
        catch (KernelException e) {
            throw new IllegalStateException("Indexed node should exist and have the indexed property.", e);
        }
    }

    protected void doCollect(int doc) throws IOException, KernelException, IndexEntryConflictException {
        Document document = this.reader.document(doc);
        long nodeId = LuceneDocumentStructure.getNodeId(document);
        Value value = this.accessor.getNodePropertyValue(nodeId, this.propertyKeyId, PageCursorTracer.NULL);
        this.duplicateCheckStrategy.checkForDuplicate(value, nodeId);
    }

    protected void doSetNextReader(LeafReaderContext context) {
        this.reader = context.reader();
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public void init() {
        this.duplicateCheckStrategy = new DuplicateCheckStrategy.BucketsDuplicateCheckStrategy();
    }

    public void init(int expectedNumberOfEntries) {
        this.duplicateCheckStrategy = this.useFastCheck(expectedNumberOfEntries) ? new DuplicateCheckStrategy.MapDuplicateCheckStrategy(expectedNumberOfEntries) : new DuplicateCheckStrategy.BucketsDuplicateCheckStrategy(expectedNumberOfEntries);
    }

    private boolean useFastCheck(int expectedNumberOfEntries) {
        return expectedNumberOfEntries <= 10000;
    }
}

