/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.NonUniqueIndexSampler;

public class DefaultNonUniqueIndexSampler
implements NonUniqueIndexSampler {
    private final int sampleSizeLimit;
    private final MutableObjectLongMap<String> values;
    private int sampledSteps;
    private long accumulatedUniqueValues;
    private long accumulatedSampledSize;
    private long sampleSize;

    public DefaultNonUniqueIndexSampler(int sampleSizeLimit) {
        this.values = new ObjectLongHashMap(DefaultNonUniqueIndexSampler.calculateInitialSetSize(sampleSizeLimit));
        this.sampleSizeLimit = sampleSizeLimit;
    }

    public void include(String value) {
        this.include(value, 1L);
    }

    public void include(String value, long increment) {
        assert (increment > 0L);
        if (this.sampleSize >= (long)this.sampleSizeLimit) {
            this.nextStep();
        }
        if (this.values.addToValue((Object)value, increment) == increment) {
            this.sampleSize += (long)value.length();
        }
    }

    public void exclude(String value) {
        this.exclude(value, 1L);
    }

    public void exclude(String value, long decrement) {
        assert (decrement > 0L);
        if (this.values.addToValue((Object)value, -decrement) <= 0L) {
            this.values.remove((Object)value);
            this.sampleSize -= (long)value.length();
        }
    }

    public IndexSample sample(PageCursorTracer cursorTracer) {
        return this.sample(-1, cursorTracer);
    }

    public IndexSample sample(int numDocs, PageCursorTracer cursorTracer) {
        if (!this.values.isEmpty()) {
            this.nextStep();
        }
        long uniqueValues = this.sampledSteps != 0 ? this.accumulatedUniqueValues / (long)this.sampledSteps : 0L;
        long sampledSize = this.sampledSteps != 0 ? this.accumulatedSampledSize / (long)this.sampledSteps : 0L;
        return new IndexSample(numDocs < 0 ? this.accumulatedSampledSize : (long)numDocs, uniqueValues, sampledSize);
    }

    private void nextStep() {
        this.accumulatedUniqueValues += (long)this.values.size();
        this.accumulatedSampledSize += this.values.sum();
        this.sampleSize = 0L;
        ++this.sampledSteps;
        this.values.clear();
    }

    private static int calculateInitialSetSize(int sampleSizeLimit) {
        int basedOnSampleSize = Math.max(10, (int)(Math.log(sampleSizeLimit) / Math.log(2.0)) / 2);
        return 1 << Math.min(16, basedOnSampleSize);
    }
}

