/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.File;
import java.util.Objects;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;

public class StoreLayout {
    private static final String STORE_LOCK_FILENAME = "store_lock";
    private final File storeDirectory;

    public static StoreLayout of(File storeDirectory) {
        return new StoreLayout(FileUtils.getCanonicalFile(storeDirectory));
    }

    private StoreLayout(File rootStoreDirectory) {
        this.storeDirectory = rootStoreDirectory;
    }

    public DatabaseLayout databaseLayout(String databaseName) {
        return DatabaseLayout.of(this.storeDirectory, databaseName);
    }

    public File storeDirectory() {
        return this.storeDirectory;
    }

    public File storeLockFile() {
        return new File(this.storeDirectory, STORE_LOCK_FILENAME);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreLayout that = (StoreLayout)o;
        return Objects.equals(this.storeDirectory, that.storeDirectory);
    }

    public int hashCode() {
        return Objects.hash(this.storeDirectory);
    }

    public String toString() {
        return String.valueOf(this.storeDirectory);
    }
}

