/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs.watcher;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.resource.WatchedFile;
import org.neo4j.io.fs.watcher.resource.WatchedResource;

public class DefaultFileSystemWatcher
implements FileWatcher {
    private static final WatchEvent.Kind[] OBSERVED_EVENTS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private final WatchService watchService;
    private final List<FileWatchEventListener> listeners = new CopyOnWriteArrayList<FileWatchEventListener>();
    private volatile boolean watch;

    public DefaultFileSystemWatcher(WatchService watchService) {
        this.watchService = watchService;
    }

    @Override
    public WatchedResource watch(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(String.format("File `%s` is not a directory. Only directories can be registered to be monitored.", file.getCanonicalPath()));
        }
        WatchKey watchKey = file.toPath().register(this.watchService, OBSERVED_EVENTS, SensitivityWatchEventModifier.HIGH);
        return new WatchedFile(watchKey);
    }

    @Override
    public void startWatching() throws InterruptedException {
        this.watch = true;
        while (this.watch) {
            WatchKey key = this.watchService.take();
            if (key == null) continue;
            List<WatchEvent<?>> watchEvents = key.pollEvents();
            for (WatchEvent<?> watchEvent : watchEvents) {
                WatchEvent.Kind<?> kind = watchEvent.kind();
                if (StandardWatchEventKinds.ENTRY_MODIFY == kind) {
                    this.notifyAboutModification(watchEvent);
                }
                if (StandardWatchEventKinds.ENTRY_DELETE != kind) continue;
                this.notifyAboutDeletion(watchEvent);
            }
            key.reset();
        }
    }

    @Override
    public void stopWatching() {
        this.watch = false;
    }

    @Override
    public void addFileWatchEventListener(FileWatchEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeFileWatchEventListener(FileWatchEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void close() throws IOException {
        this.stopWatching();
        this.watchService.close();
    }

    private void notifyAboutModification(WatchEvent<?> watchEvent) {
        String context = DefaultFileSystemWatcher.getContext(watchEvent);
        if (StringUtils.isNotEmpty((CharSequence)context)) {
            for (FileWatchEventListener listener : this.listeners) {
                listener.fileModified(context);
            }
        }
    }

    private void notifyAboutDeletion(WatchEvent<?> watchEvent) {
        String context = DefaultFileSystemWatcher.getContext(watchEvent);
        if (StringUtils.isNotEmpty((CharSequence)context)) {
            for (FileWatchEventListener listener : this.listeners) {
                listener.fileDeleted(context);
            }
        }
    }

    private static String getContext(WatchEvent<?> watchEvent) {
        return Objects.toString(watchEvent.context(), "");
    }
}

