/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.impl.api.RelationshipDataExtractor;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;

public abstract class CompiledExpandUtils {
    public static RelationshipIterator connectingRelationships(ReadOperations readOperations, long fromNode, Direction direction, long toNode) throws EntityNotFoundException {
        Direction relDirection;
        long endNode;
        long startNode;
        int fromDegree = readOperations.nodeGetDegree(fromNode, direction);
        if (fromDegree == 0) {
            return RelationshipIterator.EMPTY;
        }
        int toDegree = readOperations.nodeGetDegree(toNode, direction.reverse());
        if (toDegree == 0) {
            return RelationshipIterator.EMPTY;
        }
        if (fromDegree < toDegree) {
            startNode = fromNode;
            endNode = toNode;
            relDirection = direction;
        } else {
            startNode = toNode;
            endNode = fromNode;
            relDirection = direction.reverse();
        }
        RelationshipIterator allRelationships = readOperations.nodeGetRelationships(startNode, relDirection);
        return CompiledExpandUtils.connectingRelationshipsIterator(allRelationships, startNode, endNode);
    }

    public static RelationshipIterator connectingRelationships(ReadOperations readOperations, long fromNode, Direction direction, long toNode, int ... relTypes) throws EntityNotFoundException {
        Direction relDirection;
        long endNode;
        long startNode;
        int fromDegree = CompiledExpandUtils.calculateTotalDegree(readOperations, fromNode, direction, relTypes);
        if (fromDegree == 0) {
            return RelationshipIterator.EMPTY;
        }
        int toDegree = CompiledExpandUtils.calculateTotalDegree(readOperations, toNode, direction.reverse(), relTypes);
        if (toDegree == 0) {
            return RelationshipIterator.EMPTY;
        }
        if (fromDegree < toDegree) {
            startNode = fromNode;
            endNode = toNode;
            relDirection = direction;
        } else {
            startNode = toNode;
            endNode = fromNode;
            relDirection = direction.reverse();
        }
        RelationshipIterator allRelationships = readOperations.nodeGetRelationships(startNode, relDirection, relTypes);
        return CompiledExpandUtils.connectingRelationshipsIterator(allRelationships, startNode, endNode);
    }

    private static int calculateTotalDegree(ReadOperations readOperations, long fromNode, Direction direction, int[] relTypes) throws EntityNotFoundException {
        int degree = 0;
        for (int relType : relTypes) {
            degree += readOperations.nodeGetDegree(fromNode, direction, relType);
        }
        return degree;
    }

    private static RelationshipIterator connectingRelationshipsIterator(final RelationshipIterator allRelationships, final long fromNode, final long toNode) {
        return new RelationshipIterator.BaseIterator(){
            private final RelationshipDataExtractor extractor = new RelationshipDataExtractor();

            public <EXCEPTION extends Exception> boolean relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> visitor) throws EXCEPTION {
                visitor.visit(this.extractor.relationship(), this.extractor.type(), this.extractor.startNode(), this.extractor.endNode());
                return false;
            }

            protected boolean fetchNext() {
                while (allRelationships.hasNext()) {
                    allRelationships.relationshipVisit(allRelationships.next(), (RelationshipVisitor)this.extractor);
                    if (this.extractor.otherNode(fromNode) != toNode) continue;
                    this.next = this.extractor.relationship();
                    return true;
                }
                return false;
            }
        };
    }
}

