/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.planner.logical;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.semantics.SemanticState;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.phases.CompilationContains;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.compiler.phases.PlannerContext;
import org.neo4j.cypher.internal.compiler.planner.logical.LeafPlanUpdater;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.planner.logical.LogicalPlanningContext$;
import org.neo4j.cypher.internal.compiler.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.planner.logical.QueryGraphSolver;
import org.neo4j.cypher.internal.compiler.planner.logical.QueryPlannerConfiguration;
import org.neo4j.cypher.internal.compiler.planner.logical.QueryPlannerConfiguration$;
import org.neo4j.cypher.internal.compiler.planner.logical.ReportCostComparisonsAsRows;
import org.neo4j.cypher.internal.compiler.planner.logical.plannerQueryPartPlanner$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.CostComparisonListener;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.LogicalPlanProducer;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.SystemOutCostLogger$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.devNullListener$;
import org.neo4j.cypher.internal.compiler.planner.logical.steps.verifyBestPlan$;
import org.neo4j.cypher.internal.frontend.PlannerName;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Condition;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.ir.PeriodicCommit;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.PlannerQueryPart;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.planner.spi.PlanningAttributes;
import org.neo4j.cypher.internal.rewriting.rewriters.InnerVariableNamer;
import org.neo4j.cypher.internal.util.Cost;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.cypher.internal.util.attribution.IdGen;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class QueryPlanner$
implements Phase<PlannerContext, LogicalPlanState, LogicalPlanState>,
Product,
scala.Serializable {
    public static QueryPlanner$ MODULE$;

    static {
        new QueryPlanner$();
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.transform$((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.name$((Phase)this);
    }

    public <D extends PlannerContext, TO2> Transformer<D, LogicalPlanState, TO2> andThen(Transformer<D, LogicalPlanState, TO2> other) {
        return Transformer.andThen$((Transformer)this, other);
    }

    public Transformer<PlannerContext, LogicalPlanState, LogicalPlanState> adds(Condition condition) {
        return Transformer.adds$((Transformer)this, (Condition)condition);
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.LOGICAL_PLANNING;
    }

    public String description() {
        return "using cost estimates, plan the query to a logical plan";
    }

    public Set<Condition> postConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Condition[]{new CompilationContains(ClassTag$.MODULE$.apply(LogicalPlan.class), ManifestFactory$.MODULE$.classType(LogicalPlan.class))}));
    }

    public LogicalPlanState process(LogicalPlanState from, PlannerContext context) {
        LogicalPlanState logicalPlanState;
        boolean printCostComparisons;
        boolean costComparisonsAsRows = context.debugOptions().contains((Object)"reportcostcomparisonsasrows");
        boolean bl = printCostComparisons = context.debugOptions().contains((Object)"printcostcomparisons") || Boolean.getBoolean("pickBestPlan.VERBOSE");
        CostComparisonListener costComparisonListener = costComparisonsAsRows ? new ReportCostComparisonsAsRows() : (printCostComparisons ? SystemOutCostLogger$.MODULE$ : devNullListener$.MODULE$);
        PlanningAttributes planningAttributes = from.planningAttributes();
        LogicalPlanProducer logicalPlanProducer = new LogicalPlanProducer(context.metrics().cardinality(), planningAttributes, context.logicalPlanIdGen());
        PlanContext x$12 = context.planContext();
        LogicalPlanProducer x$2 = logicalPlanProducer;
        Metrics x$3 = this.getMetricsFrom(context);
        SemanticTable x$4 = from.semanticTable();
        QueryGraphSolver x$5 = context.queryGraphSolver();
        InternalNotificationLogger x$6 = context.notificationLogger();
        boolean x$7 = context.config().useErrorsOverWarnings();
        boolean x$8 = context.config().errorIfShortestPathFallbackUsedAtRuntime();
        boolean x$9 = context.config().errorIfShortestPathHasCommonNodesAtRuntime();
        QueryPlannerConfiguration x$10 = QueryPlannerConfiguration$.MODULE$.default().withUpdateStrategy(context.updateStrategy());
        boolean x$11 = context.config().legacyCsvQuoteEscaping();
        int x$122 = context.config().csvBufferSize();
        CostComparisonListener x$13 = costComparisonListener;
        PlanningAttributes x$14 = planningAttributes;
        InnerVariableNamer x$15 = context.innerVariableNamer();
        IdGen x$16 = context.logicalPlanIdGen();
        Metrics.QueryGraphSolverInput x$17 = LogicalPlanningContext$.MODULE$.apply$default$6();
        LeafPlanUpdater x$18 = LogicalPlanningContext$.MODULE$.apply$default$14();
        Set<Tuple2<String, String>> x$19 = LogicalPlanningContext$.MODULE$.apply$default$18();
        LogicalPlanningContext logicalPlanningContext = new LogicalPlanningContext(x$12, x$2, x$3, x$4, x$5, x$17, x$6, x$7, x$8, x$9, x$11, x$122, x$10, x$18, x$13, x$14, x$15, x$19, x$16);
        List produceResultColumns = (List)from.statement().returnColumns().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), List$.MODULE$.canBuildFrom());
        Tuple3<Option<PeriodicCommit>, LogicalPlan, LogicalPlanningContext> tuple3 = this.plan(from.query(), logicalPlanningContext, (Seq<String>)produceResultColumns);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Option perCommit = (Option)tuple3._1();
        LogicalPlan logicalPlan = (LogicalPlan)tuple3._2();
        LogicalPlanningContext newLogicalPlanningContext = (LogicalPlanningContext)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)perCommit, (Object)logicalPlan, (Object)newLogicalPlanningContext);
        Tuple3 tuple33 = tuple32;
        Option perCommit2 = (Option)tuple33._1();
        LogicalPlan logicalPlan2 = (LogicalPlan)tuple33._2();
        LogicalPlanningContext newLogicalPlanningContext2 = (LogicalPlanningContext)tuple33._3();
        CostComparisonListener costComparisonListener2 = costComparisonListener;
        if (costComparisonListener2 instanceof ReportCostComparisonsAsRows) {
            CostComparisonListener costComparisonListener3 = costComparisonListener2;
            logicalPlanState = ((ReportCostComparisonsAsRows)costComparisonListener3).addPlan(from);
        } else {
            Some x$20 = new Some((Object)perCommit2);
            Some x$21 = new Some((Object)logicalPlan2);
            Some x$22 = new Some((Object)newLogicalPlanningContext2.semanticTable());
            String x$23 = from.copy$default$1();
            Option<InputPosition> x$24 = from.copy$default$2();
            PlannerName x$25 = from.copy$default$3();
            PlanningAttributes x$26 = from.copy$default$4();
            Option<Statement> x$27 = from.copy$default$5();
            Option<SemanticState> x$28 = from.copy$default$6();
            Option<Map<String, Object>> x$29 = from.copy$default$7();
            Option<PlannerQuery> x$30 = from.copy$default$9();
            Set<Condition> x$31 = from.copy$default$12();
            Map<String, CypherType> x$32 = from.copy$default$13();
            boolean x$33 = from.copy$default$14();
            Option<Seq<String>> x$34 = from.copy$default$15();
            Option<ObfuscationMetadata> x$35 = from.copy$default$16();
            logicalPlanState = from.copy(x$23, x$24, x$25, x$26, x$27, x$28, x$29, (Option<SemanticTable>)x$22, x$30, (Option<LogicalPlan>)x$21, (Option<Option<PeriodicCommit>>)x$20, x$31, x$32, x$33, x$34, x$35);
        }
        return logicalPlanState;
    }

    private Metrics getMetricsFrom(PlannerContext context) {
        return context.debugOptions().contains((Object)"inverse_cost") ? context.metrics().copy(new Function3<LogicalPlan, Metrics.QueryGraphSolverInput, PlanningAttributes.Cardinalities, Cost>(context){
            private final PlannerContext context$1;

            public Function1<LogicalPlan, Function1<Metrics.QueryGraphSolverInput, Function1<PlanningAttributes.Cardinalities, Cost>>> curried() {
                return Function3.curried$((Function3)this);
            }

            public Function1<Tuple3<LogicalPlan, Metrics.QueryGraphSolverInput, PlanningAttributes.Cardinalities>, Cost> tupled() {
                return Function3.tupled$((Function3)this);
            }

            public String toString() {
                return Function3.toString$((Function3)this);
            }

            public Cost apply(LogicalPlan v1, Metrics.QueryGraphSolverInput v2, PlanningAttributes.Cardinalities v3) {
                return ((Cost)this.context$1.metrics().cost().apply((Object)v1, (Object)v2, (Object)v3)).unary_$minus();
            }
            {
                this.context$1 = context$1;
                Function3.$init$((Function3)this);
            }
        }, context.metrics().copy$default$2(), context.metrics().copy$default$3()) : context.metrics();
    }

    public Tuple3<Option<PeriodicCommit>, LogicalPlan, LogicalPlanningContext> plan(PlannerQuery query, LogicalPlanningContext context, Seq<String> produceResultColumns) {
        None$ none$;
        Tuple2<LogicalPlan, LogicalPlanningContext> tuple2 = plannerQueryPartPlanner$.MODULE$.plan(query.query(), context, plannerQueryPartPlanner$.MODULE$.plan$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LogicalPlan plan = (LogicalPlan)tuple2._1();
        LogicalPlanningContext newContext = (LogicalPlanningContext)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)plan, (Object)newContext);
        Tuple2 tuple23 = tuple22;
        LogicalPlan plan2 = (LogicalPlan)tuple23._1();
        LogicalPlanningContext newContext2 = (LogicalPlanningContext)tuple23._2();
        PlannerQueryPart plannerQueryPart = query.query();
        if (plannerQueryPart instanceof SinglePlannerQuery) {
            SinglePlannerQuery singlePlannerQuery = (SinglePlannerQuery)plannerQueryPart;
            none$ = new Some((Object)singlePlannerQuery.last().interestingOrder());
        } else {
            none$ = None$.MODULE$;
        }
        None$ lastInterestingOrder = none$;
        LogicalPlan planWithProduceResults = newContext2.logicalPlanProducer().planProduceResult(plan2, produceResultColumns, (Option<InterestingOrder>)lastInterestingOrder, newContext2);
        verifyBestPlan$.MODULE$.apply(planWithProduceResults, query.query(), newContext2);
        return new Tuple3((Object)query.periodicCommit(), (Object)planWithProduceResults, (Object)newContext2);
    }

    public String productPrefix() {
        return "QueryPlanner";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof QueryPlanner$;
    }

    public int hashCode() {
        return 1113900042;
    }

    public String toString() {
        return "QueryPlanner";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private QueryPlanner$() {
        MODULE$ = this;
        Transformer.$init$((Transformer)this);
        Phase.$init$((Phase)this);
        Product.$init$((Product)this);
    }
}

