/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractStatement;
import org.neo4j.cypherdsl.core.Clause;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.RendererBridge;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.INTERNAL, since="1.0")
class SinglePartQuery
extends AbstractStatement
implements Statement.SingleQuery {
    private final List<Visitable> precedingClauses;

    private SinglePartQuery(List<Visitable> precedingClauses) {
        this.precedingClauses = new ArrayList<Visitable>(precedingClauses);
    }

    static SinglePartQuery create(List<Visitable> precedingClauses, Clause returnOrFinish) {
        if (precedingClauses.isEmpty() || precedingClauses.get(precedingClauses.size() - 1) instanceof Match) {
            Assertions.notNull(returnOrFinish, "A returning or finishing clause is required.");
        }
        if (returnOrFinish == null) {
            if (precedingClauses.get(precedingClauses.size() - 1) instanceof ResultStatement) {
                return new SinglePartQueryAsResultStatementWrapper(precedingClauses);
            }
            return new SinglePartQuery(precedingClauses);
        }
        return new SinglePartQueryWithFinishingClause(precedingClauses, returnOrFinish);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.precedingClauses.forEach(c -> c.accept(visitor));
        visitor.leave(this);
    }

    static final class SinglePartQueryAsResultStatementWrapper
    extends SinglePartQuery
    implements ResultStatement {
        private SinglePartQueryAsResultStatementWrapper(List<Visitable> precedingClauses) {
            super(precedingClauses);
        }
    }

    static final class SinglePartQueryWithFinishingClause
    extends SinglePartQuery
    implements ResultStatement {
        private final Clause finishingClause;

        private SinglePartQueryWithFinishingClause(List<Visitable> precedingClauses, Clause finishingClause) {
            super(precedingClauses);
            this.finishingClause = finishingClause;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            this.precedingClauses.forEach(c -> c.accept(visitor));
            this.finishingClause.accept(visitor);
            visitor.leave(this);
        }

        @Override
        public String toString() {
            return RendererBridge.render(this);
        }
    }
}

