/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractClause;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.UpdatingClause;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.STABLE, since="1.0")
public final class Delete
extends AbstractClause
implements UpdatingClause {
    private final ExpressionList deleteItems;
    private final boolean detach;

    Delete(ExpressionList deleteItems, boolean detach) {
        this.deleteItems = deleteItems;
        this.detach = detach;
    }

    static Delete delete(Expression toBeDeleted, Expression ... more) {
        return Delete.delete(false, toBeDeleted, more);
    }

    static Delete delete(boolean detach, Expression toBeDeleted, Expression ... more) {
        if (more == null || more.length == 0) {
            return new Delete(new ExpressionList(List.of(toBeDeleted)), detach);
        }
        ArrayList<Expression> finalExpressionList = new ArrayList<Expression>();
        finalExpressionList.add(toBeDeleted);
        Collections.addAll(finalExpressionList, more);
        return new Delete(new ExpressionList((List<Expression>)finalExpressionList), detach);
    }

    static Delete detachDelete(Expression toBeDeleted, Expression ... more) {
        return Delete.delete(true, toBeDeleted, more);
    }

    @API(status=API.Status.INTERNAL)
    public boolean isDetach() {
        return this.detach;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.deleteItems.accept(visitor);
        visitor.leave(this);
    }
}

