/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.cypherdsl.build.RegisterForReflection;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.NestedExpression;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.ast.EnterResult;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.ast.VisitorWithResult;
import org.neo4j.cypherdsl.core.renderer.DefaultVisitor;

@RegisterForReflection(allDeclaredConstructors=true)
final class Neo4j5FunctionInvocationVisitor
implements Visitor {
    private final DefaultVisitor delegate;

    Neo4j5FunctionInvocationVisitor(DefaultVisitor delegate) {
        this.delegate = delegate;
    }

    @Override
    public void enter(Visitable visitable) {
        FunctionInvocation functionInvocation = (FunctionInvocation)visitable;
        if ("distance".equals(functionInvocation.getFunctionName())) {
            this.delegate.builder.append("point.distance(");
        } else if ("elementId".equals(functionInvocation.getFunctionName())) {
            this.delegate.builder.append("elementId(");
        } else if (!Neo4j5FunctionInvocationVisitor.isNPropExists(visitable)) {
            this.delegate.enter(functionInvocation);
        }
    }

    @Override
    public void leave(Visitable visitable) {
        FunctionInvocation functionInvocation = (FunctionInvocation)visitable;
        if (Neo4j5FunctionInvocationVisitor.isNPropExists(visitable)) {
            this.delegate.builder.append(" IS NOT NULL");
        } else if ("elementId".equals(functionInvocation.getFunctionName())) {
            this.delegate.builder.append(")");
        } else {
            this.delegate.leave(functionInvocation);
        }
    }

    static boolean isNPropExists(Visitable visitable) {
        if (visitable instanceof NestedExpression) {
            final AtomicReference capture = new AtomicReference();
            visitable.accept(new VisitorWithResult(){

                @Override
                public EnterResult enterWithResult(Visitable segment) {
                    if (segment instanceof NestedExpression) {
                        return EnterResult.CONTINUE;
                    }
                    return capture.compareAndSet(null, segment) ? EnterResult.SKIP_CHILDREN : EnterResult.CONTINUE;
                }
            });
            visitable = (Visitable)capture.get();
        }
        if (!(visitable instanceof FunctionInvocation)) {
            return false;
        }
        FunctionInvocation functionInvocation = (FunctionInvocation)visitable;
        if ("exists".equals(functionInvocation.getFunctionName())) {
            SingleArgExtractor<Property> singleArgExtractor = new SingleArgExtractor<Property>(Property.class);
            functionInvocation.accept(singleArgExtractor);
            return singleArgExtractor.singleArg != null;
        }
        return false;
    }

    static class SingleArgExtractor<T>
    extends VisitorWithResult {
        final Class<T> expectedType;
        boolean insideArguments;
        int level = 0;
        T singleArg;

        SingleArgExtractor(Class<T> expectedType) {
            this.expectedType = expectedType;
        }

        @Override
        public EnterResult enterWithResult(Visitable segment) {
            if (segment instanceof NestedExpression) {
                return EnterResult.CONTINUE;
            }
            if (++this.level == 2) {
                this.insideArguments = true;
            }
            if (this.insideArguments && this.level == 3 && this.expectedType.isInstance(segment)) {
                this.singleArg = this.singleArg == null ? segment : null;
            }
            return EnterResult.CONTINUE;
        }

        @Override
        public void leave(Visitable segment) {
            this.insideArguments = this.level-- != 2;
        }
    }
}

