/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Asterisk;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class MapProjection
implements Expression {
    private SymbolicName name;
    private MapExpression map;

    static MapProjection create(SymbolicName name, Object ... content) {
        return new MapProjection(name, MapExpression.withEntries(MapProjection.createNewContent(content)));
    }

    MapProjection(SymbolicName name, MapExpression map) {
        this.name = name;
        this.map = map;
    }

    @NotNull
    @Contract(pure=true)
    public MapProjection and(Object ... content) {
        return new MapProjection(this.name, this.map.addEntries(MapProjection.createNewContent(content)));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.name.accept(visitor);
        this.map.accept(visitor);
        visitor.leave(this);
    }

    private static Object contentAt(Object[] content, int i) {
        Object currentObject = content[i];
        if (currentObject instanceof Expression) {
            return Expressions.nameOrExpression((Expression)currentObject);
        }
        if (currentObject instanceof Named) {
            return ((Named)currentObject).getSymbolicName().map(Object.class::cast).orElse(currentObject);
        }
        return currentObject;
    }

    private static List<Expression> createNewContent(Object ... content) {
        ArrayList<Expression> newContent = new ArrayList<Expression>(content.length);
        HashSet<String> knownKeys = new HashSet<String>();
        String lastKey = null;
        Expression lastExpression = null;
        int i = 0;
        while (i < content.length) {
            Object next = i + 1 >= content.length ? null : MapProjection.contentAt(content, i + 1);
            Object current = MapProjection.contentAt(content, i);
            if (current instanceof String) {
                if (next instanceof Expression) {
                    lastKey = (String)current;
                    lastExpression = (Expression)next;
                    i += 2;
                } else {
                    lastKey = null;
                    lastExpression = PropertyLookup.forName((String)current);
                    ++i;
                }
            } else if (current instanceof Expression) {
                lastKey = null;
                lastExpression = (Expression)current;
                ++i;
            }
            if (lastExpression instanceof Asterisk) {
                lastExpression = PropertyLookup.wildcard();
            }
            if (lastKey != null) {
                Assertions.isTrue(!knownKeys.contains(lastKey), "Duplicate key '" + lastKey + "'");
                newContent.add(new KeyValueMapEntry(lastKey, lastExpression));
                knownKeys.add(lastKey);
            } else if (lastExpression instanceof SymbolicName || lastExpression instanceof PropertyLookup) {
                newContent.add(lastExpression);
            } else if (lastExpression instanceof Property) {
                List<PropertyLookup> names = ((Property)lastExpression).getNames();
                if (names.size() > 1) {
                    throw new IllegalArgumentException("Cannot project nested properties!");
                }
                newContent.addAll(names);
            } else if (lastExpression instanceof AliasedExpression) {
                AliasedExpression aliasedExpression = (AliasedExpression)lastExpression;
                newContent.add(new KeyValueMapEntry(aliasedExpression.getAlias(), aliasedExpression));
            } else {
                if (lastExpression == null) {
                    throw new IllegalArgumentException("Could not determine an expression from the given content!");
                }
                throw new IllegalArgumentException(lastExpression + " of type " + lastExpression.getClass() + " cannot be used with an implicit name as map entry.");
            }
            lastKey = null;
            lastExpression = null;
        }
        return newContent;
    }
}

