/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Aliased;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class AliasedExpression
implements Aliased,
Expression {
    private final Expression delegate;
    private final String alias;

    AliasedExpression(Expression delegate, String alias) {
        this.delegate = delegate;
        this.alias = alias;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public AliasedExpression as(String newAlias) {
        Assertions.hasText(newAlias, "The alias may not be null or empty.");
        return new AliasedExpression(this.delegate, newAlias);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Expressions.nameOrExpression(this.delegate).accept(visitor);
        visitor.leave(this);
    }
}

