/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.NumberLiteral;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Limit
implements Visitable {
    private final NumberLiteral limitAmount;

    static Limit create(Number value) {
        Assertions.notNull(value, "A limit cannot have a null value.");
        return new Limit(new NumberLiteral(value));
    }

    private Limit(NumberLiteral limitAmount) {
        this.limitAmount = limitAmount;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.limitAmount.accept(visitor);
        visitor.leave(this);
    }
}

