/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.TimeZone;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.BuiltInFunctions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.NamedPath;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NumberLiteral;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Functions {
    public static FunctionInvocation id(Node node) {
        Assertions.notNull(node, "The node for id() is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.ID, node.getRequiredSymbolicName());
    }

    public static FunctionInvocation id(Relationship relationship) {
        Assertions.notNull(relationship, "The relationship for id() is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.ID, relationship.getRequiredSymbolicName());
    }

    public static FunctionInvocation labels(Node node) {
        Assertions.notNull(node, "The node parameter is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.LABELS, node.getRequiredSymbolicName());
    }

    public static FunctionInvocation type(Relationship relationship) {
        Assertions.notNull(relationship, "The relationship parameter is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.TYPE, relationship.getRequiredSymbolicName());
    }

    public static FunctionInvocation count(Node node) {
        Assertions.notNull(node, "The node parameter is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COUNT, node.getRequiredSymbolicName());
    }

    public static FunctionInvocation count(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COUNT, expression);
    }

    public static FunctionInvocation countDistinct(Node node) {
        Assertions.notNull(node, "The node parameter is required.");
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COUNT, node.getRequiredSymbolicName());
    }

    public static FunctionInvocation countDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COUNT, expression);
    }

    public static FunctionInvocation properties(Node node) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.PROPERTIES, node.getRequiredSymbolicName());
    }

    public static FunctionInvocation properties(Relationship relationship) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.PROPERTIES, relationship.getRequiredSymbolicName());
    }

    public static FunctionInvocation properties(MapExpression map) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.PROPERTIES, map);
    }

    public static FunctionInvocation coalesce(Expression ... expressions) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.COALESCE, expressions);
    }

    public static FunctionInvocation toLower(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.TO_LOWER, expression);
    }

    public static FunctionInvocation size(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SIZE, expression);
    }

    public static FunctionInvocation size(RelationshipPattern pattern) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SIZE, pattern);
    }

    public static FunctionInvocation exists(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Predicates.EXISTS, expression);
    }

    public static FunctionInvocation distance(Expression point1, Expression point2) {
        Assertions.notNull(point1, "The distance function requires two points.");
        Assertions.notNull(point2, "The distance function requires two points.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Spatials.DISTANCE, point1, point2);
    }

    public static FunctionInvocation point(MapExpression parameterMap) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Spatials.POINT, parameterMap);
    }

    public static FunctionInvocation point(Parameter parameter) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Spatials.POINT, parameter);
    }

    public static FunctionInvocation avg(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.AVG, expression);
    }

    public static FunctionInvocation avgDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.AVG, expression);
    }

    public static FunctionInvocation collect(Named variable) {
        Assertions.notNull(variable, "The variable parameter is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COLLECT, variable.getRequiredSymbolicName());
    }

    public static FunctionInvocation collectDistinct(Named variable) {
        Assertions.notNull(variable, "The variable parameter is required.");
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COLLECT, variable.getRequiredSymbolicName());
    }

    public static FunctionInvocation collect(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COLLECT, expression);
    }

    public static FunctionInvocation collectDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COLLECT, expression);
    }

    public static FunctionInvocation max(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.MAX, expression);
    }

    public static FunctionInvocation maxDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.MAX, expression);
    }

    public static FunctionInvocation min(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.MIN, expression);
    }

    public static FunctionInvocation minDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.MIN, expression);
    }

    private static void assertPercentileArguments(BuiltInFunctions.Aggregates builtIn, Expression expression, Number percentile) {
        Assertions.notNull(expression, "The numeric expression for " + builtIn.getImplementationName() + " is required.");
        Assertions.notNull(percentile, "The percentile for " + builtIn.getImplementationName() + " is required.");
        double p = percentile.doubleValue();
        Assertions.isTrue(p >= 0.0 && p <= 1.0, "The percentile for " + builtIn.getImplementationName() + " must be between 0.0 and 1.0.");
    }

    public static FunctionInvocation percentileCont(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, percentile);
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, new NumberLiteral(percentile));
    }

    public static FunctionInvocation percentileContDistinct(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, percentile);
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, new NumberLiteral(percentile));
    }

    public static FunctionInvocation percentileDisc(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, percentile);
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, new NumberLiteral(percentile));
    }

    public static FunctionInvocation percentileDiscDistinct(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, percentile);
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, new NumberLiteral(percentile));
    }

    public static FunctionInvocation stDev(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.ST_DEV, expression);
    }

    public static FunctionInvocation stDevDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.ST_DEV, expression);
    }

    public static FunctionInvocation stDevP(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.ST_DEV_P, expression);
    }

    public static FunctionInvocation stDevPDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.ST_DEV_P, expression);
    }

    public static FunctionInvocation sum(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.SUM, expression);
    }

    public static FunctionInvocation sumDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.SUM, expression);
    }

    public static FunctionInvocation range(Integer start, Integer end) {
        return Functions.range(Cypher.literalOf(start), Cypher.literalOf(end));
    }

    public static FunctionInvocation range(Expression start, Expression end) {
        return Functions.range(start, end, null);
    }

    public static FunctionInvocation range(Integer start, Integer end, Integer step) {
        return Functions.range(Cypher.literalOf(start), Cypher.literalOf(end), Cypher.literalOf(step));
    }

    public static FunctionInvocation range(Expression start, Expression end, Expression step) {
        Assertions.notNull(start, "The expression for range is required.");
        Assertions.notNull(end, "The expression for range is required.");
        if (step == null) {
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.RANGE, start, end);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.RANGE, start, end, step);
    }

    public static FunctionInvocation head(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.HEAD, expression);
    }

    public static FunctionInvocation last(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.LAST, expression);
    }

    public static FunctionInvocation nodes(NamedPath path) {
        Assertions.notNull(path, "The path for nodes is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.NODES, path.getSymbolicName().orElseThrow(() -> new IllegalArgumentException("The path needs to be named!")));
    }

    public static FunctionInvocation relationships(NamedPath path) {
        Assertions.notNull(path, "The path for relationships is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.RELATIONSHIPS, path.getSymbolicName().orElseThrow(() -> new IllegalArgumentException("The path needs to be named!")));
    }

    public static FunctionInvocation startNode(Relationship relationship) {
        Assertions.notNull(relationship, "The relationship for endNode is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.START_NODE, relationship.getSymbolicName().orElseThrow(() -> new IllegalArgumentException("The relationship needs to be named!")));
    }

    public static FunctionInvocation endNode(Relationship relationship) {
        Assertions.notNull(relationship, "The relationship for endNode is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.END_NODE, relationship.getSymbolicName().orElseThrow(() -> new IllegalArgumentException("The relationship needs to be named!")));
    }

    public static FunctionInvocation date() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.DATE);
    }

    public static FunctionInvocation calendarDate(Integer year, Integer month, Integer day) {
        Assertions.notNull(year, "The year is required.");
        Assertions.notNull(month, "The month is required.");
        Assertions.notNull(day, "The year is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf("year", Cypher.literalOf(year), "month", Cypher.literalOf(month), "day", Cypher.literalOf(day)));
    }

    public static FunctionInvocation weekDate(Integer year, Integer week, Integer dayOfWeek) {
        Assertions.notNull(year, "The year is required.");
        Object[] parameters = new Object[2 + (week == null ? 0 : 2) + (dayOfWeek == null ? 0 : 2)];
        int i = 0;
        parameters[i++] = "year";
        parameters[i++] = Cypher.literalOf(year);
        if (week != null) {
            parameters[i++] = "week";
            parameters[i++] = Cypher.literalOf(week);
        }
        if (dayOfWeek != null) {
            if (week == null) {
                throw new IllegalArgumentException("week is required when using dayOfWeek.");
            }
            parameters[i++] = "dayOfWeek";
            parameters[i++] = Cypher.literalOf(dayOfWeek);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf(parameters));
    }

    public static FunctionInvocation quarterDate(Integer year, Integer quarter, Integer dayOfQuarter) {
        Assertions.notNull(year, "The year is required.");
        Object[] parameters = new Object[2 + (quarter == null ? 0 : 2) + (dayOfQuarter == null ? 0 : 2)];
        int i = 0;
        parameters[i++] = "year";
        parameters[i++] = Cypher.literalOf(year);
        if (quarter != null) {
            parameters[i++] = "quarter";
            parameters[i++] = Cypher.literalOf(quarter);
        }
        if (dayOfQuarter != null) {
            if (dayOfQuarter == null) {
                throw new IllegalArgumentException("quarter is required when using dayOfQuarter.");
            }
            parameters[i++] = "dayOfQuarter";
            parameters[i++] = Cypher.literalOf(dayOfQuarter);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf(parameters));
    }

    public static FunctionInvocation ordinalDate(Integer year, Integer ordinalDay) {
        Assertions.notNull(year, "The year is required.");
        Object[] parameters = new Object[2 + (ordinalDay == null ? 0 : 2)];
        int i = 0;
        parameters[i++] = "year";
        parameters[i++] = Cypher.literalOf(year);
        if (ordinalDay != null) {
            parameters[i++] = "ordinalDay";
            parameters[i++] = Cypher.literalOf(ordinalDay);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf(parameters));
    }

    public static FunctionInvocation date(MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, components);
    }

    public static FunctionInvocation date(String temporalValue) {
        Assertions.hasText(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.literalOf(temporalValue));
    }

    public static FunctionInvocation date(Expression temporalValue) {
        Assertions.notNull(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, temporalValue);
    }

    public static FunctionInvocation datetime() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.DATETIME);
    }

    public static FunctionInvocation datetime(TimeZone timeZone) {
        Assertions.notNull(timeZone, "The timezone is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    public static FunctionInvocation datetime(MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, components);
    }

    public static FunctionInvocation datetime(String temporalValue) {
        Assertions.hasText(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, Cypher.literalOf(temporalValue));
    }

    public static FunctionInvocation datetime(Expression temporalValue) {
        Assertions.notNull(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, temporalValue);
    }

    public static FunctionInvocation localdatetime() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.LOCALDATETIME);
    }

    public static FunctionInvocation localdatetime(TimeZone timeZone) {
        Assertions.notNull(timeZone, "The timezone is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    public static FunctionInvocation localdatetime(MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, components);
    }

    public static FunctionInvocation localdatetime(String temporalValue) {
        Assertions.hasText(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, Cypher.literalOf(temporalValue));
    }

    public static FunctionInvocation localdatetime(Expression temporalValue) {
        Assertions.notNull(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, temporalValue);
    }

    public static FunctionInvocation localtime() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.LOCALTIME);
    }

    public static FunctionInvocation localtime(TimeZone timeZone) {
        Assertions.notNull(timeZone, "The timezone is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    public static FunctionInvocation localtime(MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, components);
    }

    public static FunctionInvocation localtime(String temporalValue) {
        Assertions.hasText(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, Cypher.literalOf(temporalValue));
    }

    public static FunctionInvocation localtime(Expression temporalValue) {
        Assertions.notNull(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, temporalValue);
    }

    public static FunctionInvocation time() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.TIME);
    }

    public static FunctionInvocation time(TimeZone timeZone) {
        Assertions.notNull(timeZone, "The timezone is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    private static MapExpression timezoneMapLiteralOf(TimeZone timeZone) {
        return Cypher.mapOf("timezone", Cypher.literalOf(timeZone.getID()));
    }

    public static FunctionInvocation time(MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, components);
    }

    public static FunctionInvocation time(String temporalValue) {
        Assertions.hasText(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, Cypher.literalOf(temporalValue));
    }

    public static FunctionInvocation time(Expression temporalValue) {
        Assertions.notNull(temporalValue, "The temporalValue is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, temporalValue);
    }

    public static FunctionInvocation duration(MapExpression components) {
        Assertions.notNull(components, "The components is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DURATION, components);
    }

    public static FunctionInvocation duration(String temporalAmount) {
        Assertions.hasText(temporalAmount, "The temporalAmount is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DURATION, Cypher.literalOf(temporalAmount));
    }

    public static FunctionInvocation duration(Expression temporalAmount) {
        Assertions.notNull(temporalAmount, "The temporalAmount is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DURATION, temporalAmount);
    }

    public static FunctionInvocation shortestPath(Relationship relationship) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SHORTEST_PATH, relationship);
    }
}

