/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.transaction;

import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.transaction.SecurityContextWrapper;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public final class TransactionContext {
    private final GraphDatabaseAPI api;
    private final SecurityContext securityContext;

    public static TransactionContext of(GraphDatabaseAPI api, Transaction top) {
        InternalTransaction internalTransaction = (InternalTransaction)top;
        return TransactionContext.of(api, internalTransaction);
    }

    public static TransactionContext of(GraphDatabaseAPI api, InternalTransaction top) {
        return TransactionContext.of(api, top.securityContext());
    }

    public static TransactionContext of(GraphDatabaseAPI api, SecurityContext securityContext) {
        SecurityContextWrapper securityContextService = (SecurityContextWrapper)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)api, SecurityContextWrapper.class);
        securityContext = securityContextService.wrap(securityContext);
        return new TransactionContext(api, securityContext);
    }

    private TransactionContext(GraphDatabaseAPI api, SecurityContext securityContext) {
        this.api = api;
        this.securityContext = securityContext;
    }

    public String username() {
        return Neo4jProxy.username((AuthSubject)this.securityContext.subject());
    }

    public <T, E extends Exception> T apply(TxFunction<T, E> block) throws E {
        Transaction tx = this.api.beginTx();
        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
        ktx.overrideWith(this.securityContext);
        try (Transaction transaction = tx;){
            T result = block.apply(tx, ktx);
            tx.commit();
            T t = result;
            return t;
        }
    }

    public <E extends Exception> void accept(TxConsumer<E> block) throws E {
        Transaction tx = this.api.beginTx();
        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
        ktx.overrideWith(this.securityContext);
        try (Transaction transaction = tx;){
            block.accept(tx, ktx);
            tx.commit();
        }
    }

    public TransactionContext withRestrictedAccess(AccessMode.Static accessMode) {
        AccessMode restrictedMode = Neo4jProxy.newRestrictedAccessMode((AccessMode)this.securityContext.mode(), (AccessMode.Static)accessMode);
        SecurityContext newContext = this.securityContext.withMode(restrictedMode);
        return new TransactionContext(this.api, newContext);
    }

    public SecureTransaction fork() {
        InternalTransaction tx = (InternalTransaction)this.api.beginTx();
        tx.kernelTransaction().overrideWith(this.securityContext);
        return new SecureTransaction(tx);
    }

    public static final class SecureTransaction
    implements AutoCloseable {
        private final InternalTransaction tx;

        private SecureTransaction(InternalTransaction tx) {
            this.tx = tx;
        }

        public KernelTransaction kernelTransaction() {
            return this.tx.kernelTransaction();
        }

        @Override
        public void close() {
            this.tx.close();
        }
    }

    public static interface TxFunction<T, E extends Exception> {
        public T apply(Transaction var1, KernelTransaction var2) throws E;
    }

    public static interface TxConsumer<E extends Exception> {
        public void accept(Transaction var1, KernelTransaction var2) throws E;
    }
}

