/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.utils.cypher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.utils.cypher.ScalaHelpers;

@Generated(from="ScalaHelpers.scalaList", generator="Immutables")
public final class ScalaListBuilder<T> {
    private List<T> items = null;

    public final ScalaListBuilder<T> add(T element) {
        if (this.items == null) {
            this.items = new ArrayList<T>();
        }
        this.items.add(Objects.requireNonNull(element, "items element"));
        return this;
    }

    @SafeVarargs
    public final ScalaListBuilder<T> add(T ... elements) {
        if (this.items == null) {
            this.items = new ArrayList<T>();
        }
        for (T element : elements) {
            this.items.add(Objects.requireNonNull(element, "items element"));
        }
        return this;
    }

    public final ScalaListBuilder<T> items(Iterable<? extends T> elements) {
        this.items = new ArrayList<T>();
        return this.addAll(elements);
    }

    public final ScalaListBuilder<T> addAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "items element");
        if (this.items == null) {
            this.items = new ArrayList<T>();
        }
        for (T element : elements) {
            this.items.add(Objects.requireNonNull(element, "items element"));
        }
        return this;
    }

    public scala.collection.immutable.List<T> build() {
        return ScalaHelpers.scalaList(this.items == null ? Collections.emptyList() : ScalaListBuilder.createUnmodifiableList(true, this.items));
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

