/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.kernel.internal.Version;

public enum Neo4jVersion {
    V_4_1,
    V_4_2,
    V_4_3,
    V_4_4;


    public String toString() {
        switch (this) {
            case V_4_1: {
                return "4.1";
            }
            case V_4_2: {
                return "4.2";
            }
            case V_4_3: {
                return "4.3";
            }
            case V_4_4: {
                return "4.4";
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + this.name() + " (sad java \ud83d\ude1e)");
    }

    public static Neo4jVersion findNeo4jVersion() {
        return Neo4jVersionHolder.VERSION;
    }

    static String neo4jVersion() {
        String neo4jVersion = Objects.requireNonNullElse(Version.class.getPackage().getImplementationVersion(), "dev");
        Pattern pattern = Pattern.compile("(\\d+\\.\\d+(\\.\\d+)?(-?[^,]+)?).*");
        Matcher matcher = pattern.matcher(neo4jVersion);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return neo4jVersion;
    }

    static Neo4jVersion parse(String version) {
        String majorVersion;
        switch (majorVersion = Pattern.compile("[.-]").splitAsStream(version).limit(2L).collect(Collectors.joining("."))) {
            case "4.1": {
                return V_4_1;
            }
            case "4.2": {
                return V_4_2;
            }
            case "4.3": {
                return V_4_3;
            }
            case "4.4": {
                return V_4_4;
            }
        }
        throw new UnsupportedOperationException("Cannot run on Neo4j Version " + version);
    }

    private static final class Neo4jVersionHolder {
        private static final Neo4jVersion VERSION = Neo4jVersion.parse(Neo4jVersion.neo4jVersion());

        private Neo4jVersionHolder() {
        }
    }
}

