/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.KernelTransaction;

@Generated(from="GraphDatabaseApiProxy.Transactions", generator="Immutables")
public final class ImmutableTransactions
implements GraphDatabaseApiProxy.Transactions {
    private final Transaction tx;
    private final KernelTransaction ktx;

    private ImmutableTransactions(Transaction tx, KernelTransaction ktx) {
        this.tx = Objects.requireNonNull(tx, "tx");
        this.ktx = Objects.requireNonNull(ktx, "ktx");
    }

    private ImmutableTransactions(ImmutableTransactions original, Transaction tx, KernelTransaction ktx) {
        this.tx = tx;
        this.ktx = ktx;
    }

    @Override
    public Transaction tx() {
        return this.tx;
    }

    @Override
    public KernelTransaction ktx() {
        return this.ktx;
    }

    public final ImmutableTransactions withTx(Transaction value) {
        if (this.tx == value) {
            return this;
        }
        Transaction newValue = Objects.requireNonNull(value, "tx");
        return new ImmutableTransactions(this, newValue, this.ktx);
    }

    public final ImmutableTransactions withKtx(KernelTransaction value) {
        if (this.ktx == value) {
            return this;
        }
        KernelTransaction newValue = Objects.requireNonNull(value, "ktx");
        return new ImmutableTransactions(this, this.tx, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactions && this.equalTo((ImmutableTransactions)another);
    }

    private boolean equalTo(ImmutableTransactions another) {
        return this.tx.equals(another.tx) && this.ktx.equals(another.ktx);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tx.hashCode();
        h += (h << 5) + this.ktx.hashCode();
        return h;
    }

    public String toString() {
        return "Transactions{tx=" + this.tx + ", ktx=" + this.ktx + "}";
    }

    public static GraphDatabaseApiProxy.Transactions of(Transaction tx, KernelTransaction ktx) {
        return new ImmutableTransactions(tx, ktx);
    }

    public static GraphDatabaseApiProxy.Transactions copyOf(GraphDatabaseApiProxy.Transactions instance) {
        if (instance instanceof ImmutableTransactions) {
            return (ImmutableTransactions)instance;
        }
        return ImmutableTransactions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphDatabaseApiProxy.Transactions", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TX = 1L;
        private static final long INIT_BIT_KTX = 2L;
        private long initBits = 3L;
        private Transaction tx;
        private KernelTransaction ktx;

        private Builder() {
        }

        public final Builder from(GraphDatabaseApiProxy.Transactions instance) {
            Objects.requireNonNull(instance, "instance");
            this.tx(instance.tx());
            this.ktx(instance.ktx());
            return this;
        }

        public final Builder tx(Transaction tx) {
            this.tx = Objects.requireNonNull(tx, "tx");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ktx(KernelTransaction ktx) {
            this.ktx = Objects.requireNonNull(ktx, "ktx");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.tx = null;
            this.ktx = null;
            return this;
        }

        public GraphDatabaseApiProxy.Transactions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactions(null, this.tx, this.ktx);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tx");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ktx");
            }
            return "Cannot build Transactions, some of required attributes are not set " + attributes;
        }
    }
}

