/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.common.DependencyResolver;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.compat.ImmutableTransactions;
import org.neo4j.gds.compat.Neo4jVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public final class GraphDatabaseApiProxy {
    public static Neo4jVersion neo4jVersion() {
        return Neo4jVersion.findNeo4jVersion();
    }

    public static <T> T resolveDependency(GraphDatabaseService db, Class<T> dependency) {
        return GraphDatabaseApiProxy.resolveDependency(((GraphDatabaseAPI)db).getDependencyResolver(), dependency);
    }

    public static <T> T resolveDependency(DependencyResolver resolver, Class<T> dependency) {
        return (T)resolver.resolveDependency(dependency, DependencyResolver.SelectionStrategy.SINGLE);
    }

    public static void registerProcedures(GraphDatabaseService db, Class<?> ... procedureClasses) throws Exception {
        GlobalProcedures procedures = GraphDatabaseApiProxy.resolveDependency(db, GlobalProcedures.class);
        for (Class<?> clazz : procedureClasses) {
            procedures.registerProcedure(clazz);
        }
    }

    public static void registerFunctions(GraphDatabaseService db, Class<?> ... functionClasses) throws Exception {
        GlobalProcedures procedures = GraphDatabaseApiProxy.resolveDependency(db, GlobalProcedures.class);
        for (Class<?> clazz : functionClasses) {
            procedures.registerFunction(clazz);
        }
    }

    public static void registerAggregationFunctions(GraphDatabaseService db, Class<?> ... functionClasses) throws Exception {
        GlobalProcedures procedures = GraphDatabaseApiProxy.resolveDependency(db, GlobalProcedures.class);
        for (Class<?> clazz : functionClasses) {
            procedures.registerAggregationFunction(clazz);
        }
    }

    public static Node getNodeById(Transaction tx, long id) {
        try {
            return tx.getNodeById(id);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public static Node getNodeById(KernelTransaction tx, long id) {
        return GraphDatabaseApiProxy.getNodeById((Transaction)tx.internalTransaction(), id);
    }

    public static Result runQueryWithoutClosingTheResult(Transaction tx, String query, Map<String, Object> params) {
        return tx.execute(query, params);
    }

    public static Result runQueryWithoutClosingTheResult(KernelTransaction tx, String query, Map<String, Object> params) {
        return tx.internalTransaction().execute(query, params);
    }

    public static void runInTransaction(GraphDatabaseService db, Consumer<Transaction> block) {
        try (Transaction tx = db.beginTx();){
            block.accept(tx);
            tx.commit();
        }
    }

    public static <T> T applyInTransaction(GraphDatabaseService db, Function<Transaction, T> block) {
        try (Transaction tx = db.beginTx();){
            T returnValue = block.apply(tx);
            tx.commit();
            T t = returnValue;
            return t;
        }
    }

    public static KernelTransaction kernelTransaction(Transaction tx) {
        return ((InternalTransaction)tx).kernelTransaction();
    }

    public static Transactions newKernelTransaction(GraphDatabaseService db) {
        Transaction tx = db.beginTx();
        return ImmutableTransactions.of(tx, GraphDatabaseApiProxy.kernelTransaction(tx));
    }

    private GraphDatabaseApiProxy() {
        throw new UnsupportedOperationException("No instances");
    }

    @ValueClass
    public static interface Transactions
    extends AutoCloseable {
        public Transaction tx();

        public KernelTransaction ktx();

        @Override
        default public void close() {
            this.tx().commit();
            this.tx().close();
        }
    }
}

