/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.model;

import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.immutables.value.Value;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.model.ImmutableModel;
import org.neo4j.gds.model.ModelConfig;

@ValueClass
public interface Model<DATA, CONFIG extends ModelConfig & BaseConfig, INFO extends ToMapConvertible> {
    public static final String ALL_USERS = "*";
    public static final String PUBLIC_MODEL_SUFFIX = "_public";

    private static ZonedDateTime now() {
        ZoneId zoneId = (ZoneId)Config.EMPTY.get(GraphDatabaseSettings.db_temporal_timezone);
        return ZonedDateTime.now(Clock.system(zoneId != null ? zoneId : ZoneId.systemDefault()));
    }

    public String creator();

    public List<String> sharedWith();

    public String name();

    public String algoType();

    public GraphSchema graphSchema();

    public DATA data();

    public CONFIG trainConfig();

    public ZonedDateTime creationTime();

    public INFO customInfo();

    @Value.Default
    @Value.Parameter(value=false)
    default public boolean loaded() {
        return true;
    }

    @Value.Default
    @Value.Parameter(value=false)
    default public boolean stored() {
        return false;
    }

    @Value.Default
    @Value.Derived
    default public void load() {
    }

    @Value.Default
    @Value.Derived
    default public void unload() {
        throw new RuntimeException("Only stored models can be unloaded.");
    }

    default public Model<DATA, CONFIG, INFO> publish() {
        return ImmutableModel.builder().from(this).sharedWith(List.of(ALL_USERS)).name(this.name() + PUBLIC_MODEL_SUFFIX).build();
    }

    public static <D, C extends ModelConfig & BaseConfig, INFO extends ToMapConvertible> Model<D, C, INFO> of(String creator, String name, String algoType, GraphSchema graphSchema, D modelData, C trainConfig, INFO customInfo) {
        return ImmutableModel.of(creator, List.of(), name, algoType, graphSchema, modelData, trainConfig, Model.now(), customInfo);
    }
}

