/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.immutables.builder.Builder;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.ElementSchema;
import org.neo4j.gds.api.schema.ImmutableRelationshipSchema;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.core.Aggregation;

@ValueClass
public interface RelationshipSchema
extends ElementSchema<RelationshipSchema, RelationshipType, RelationshipPropertySchema> {
    @Override
    default public RelationshipSchema filter(Set<RelationshipType> relationshipTypesToKeep) {
        return RelationshipSchema.of(this.filterProperties(relationshipTypesToKeep));
    }

    @Override
    default public RelationshipSchema union(RelationshipSchema other) {
        return RelationshipSchema.of(this.unionSchema(other.properties()));
    }

    default public Set<RelationshipType> availableTypes() {
        return this.properties().keySet();
    }

    default public RelationshipSchema singleTypeAndProperty(RelationshipType relationshipType, Optional<String> maybeProperty) {
        if (!this.properties().containsKey(relationshipType)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Relationship schema does not contain relationship type '%s'", relationshipType.name));
        }
        maybeProperty.ifPresent(property -> {
            if (!this.properties().get(relationshipType).containsKey(property)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Relationship schema does not contain relationship type '%s' and property '%s", relationshipType.name, property));
            }
        });
        if (maybeProperty.isPresent()) {
            return RelationshipSchema.builder().addProperty(relationshipType, maybeProperty.get(), (RelationshipPropertySchema)this.properties().get(relationshipType).get(maybeProperty.get())).build();
        }
        return RelationshipSchema.builder().addRelationshipType(relationshipType).build();
    }

    public static RelationshipSchema of(Map<RelationshipType, Map<String, RelationshipPropertySchema>> properties) {
        return RelationshipSchema.builder().properties(properties).build();
    }

    public static Builder builder() {
        return new Builder().properties(new LinkedHashMap());
    }

    @Builder.AccessibleFields
    public static class Builder
    extends ImmutableRelationshipSchema.Builder {
        public Builder addProperty(RelationshipType type, String propertyName, ValueType valueType) {
            return this.addProperty(type, propertyName, RelationshipPropertySchema.of(propertyName, valueType));
        }

        public Builder addProperty(RelationshipType type, String propertyName, ValueType valueType, Aggregation aggregation) {
            return this.addProperty(type, propertyName, RelationshipPropertySchema.of(propertyName, valueType, aggregation));
        }

        public Builder addProperty(RelationshipType type, String propertyName, RelationshipPropertySchema propertySchema) {
            this.properties.computeIfAbsent(type, ignore -> new LinkedHashMap()).put(propertyName, propertySchema);
            return this;
        }

        public Builder addRelationshipType(RelationshipType type) {
            this.properties.putIfAbsent(type, new LinkedHashMap());
            return this;
        }
    }
}

