/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.ElementSchema;
import org.neo4j.gds.api.schema.ImmutableNodeSchema;
import org.neo4j.gds.api.schema.PropertySchema;

@ValueClass
public interface NodeSchema
extends ElementSchema<NodeSchema, NodeLabel, PropertySchema> {
    @Value.Derived
    default public Set<NodeLabel> availableLabels() {
        return this.properties().keySet();
    }

    default public boolean containsOnlyAllNodesLabel() {
        return this.availableLabels().size() == 1 && this.availableLabels().contains(NodeLabel.ALL_NODES);
    }

    @Override
    default public NodeSchema filter(Set<NodeLabel> labelsToKeep) {
        return NodeSchema.of(this.filterProperties(labelsToKeep));
    }

    @Override
    default public NodeSchema union(NodeSchema other) {
        return NodeSchema.of(this.unionSchema(other.properties()));
    }

    public static NodeSchema of(Map<NodeLabel, Map<String, PropertySchema>> properties) {
        return NodeSchema.builder().properties(properties).build();
    }

    public static Builder builder() {
        return new Builder().properties(new LinkedHashMap());
    }

    @Builder.AccessibleFields
    public static class Builder
    extends ImmutableNodeSchema.Builder {
        public Builder addProperty(NodeLabel key, String propertyName, ValueType valueType) {
            return this.addProperty(key, propertyName, PropertySchema.of(propertyName, valueType, valueType.fallbackValue(), PropertyState.PERSISTENT));
        }

        public Builder addProperty(NodeLabel key, String propertyName, PropertySchema propertySchema) {
            this.properties.computeIfAbsent(key, ignore -> new LinkedHashMap()).put(propertyName, propertySchema);
            return this;
        }

        public Builder addLabel(NodeLabel key) {
            this.properties.putIfAbsent(key, Collections.emptyMap());
            return this;
        }
    }
}

