/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.api.schema.RelationshipSchema;

@Generated(from="GraphSchema", generator="Immutables")
public final class ImmutableGraphSchema
implements GraphSchema {
    private final NodeSchema nodeSchema;
    private final RelationshipSchema relationshipSchema;

    private ImmutableGraphSchema(NodeSchema nodeSchema, RelationshipSchema relationshipSchema) {
        this.nodeSchema = Objects.requireNonNull(nodeSchema, "nodeSchema");
        this.relationshipSchema = Objects.requireNonNull(relationshipSchema, "relationshipSchema");
    }

    private ImmutableGraphSchema(ImmutableGraphSchema original, NodeSchema nodeSchema, RelationshipSchema relationshipSchema) {
        this.nodeSchema = nodeSchema;
        this.relationshipSchema = relationshipSchema;
    }

    @Override
    public NodeSchema nodeSchema() {
        return this.nodeSchema;
    }

    @Override
    public RelationshipSchema relationshipSchema() {
        return this.relationshipSchema;
    }

    public final ImmutableGraphSchema withNodeSchema(NodeSchema value) {
        if (this.nodeSchema == value) {
            return this;
        }
        NodeSchema newValue = Objects.requireNonNull(value, "nodeSchema");
        return new ImmutableGraphSchema(this, newValue, this.relationshipSchema);
    }

    public final ImmutableGraphSchema withRelationshipSchema(RelationshipSchema value) {
        if (this.relationshipSchema == value) {
            return this;
        }
        RelationshipSchema newValue = Objects.requireNonNull(value, "relationshipSchema");
        return new ImmutableGraphSchema(this, this.nodeSchema, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphSchema && this.equalTo((ImmutableGraphSchema)another);
    }

    private boolean equalTo(ImmutableGraphSchema another) {
        return this.nodeSchema.equals(another.nodeSchema) && this.relationshipSchema.equals(another.relationshipSchema);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nodeSchema.hashCode();
        h += (h << 5) + this.relationshipSchema.hashCode();
        return h;
    }

    public String toString() {
        return "GraphSchema{nodeSchema=" + this.nodeSchema + ", relationshipSchema=" + this.relationshipSchema + "}";
    }

    public static GraphSchema of(NodeSchema nodeSchema, RelationshipSchema relationshipSchema) {
        return new ImmutableGraphSchema(nodeSchema, relationshipSchema);
    }

    public static GraphSchema copyOf(GraphSchema instance) {
        if (instance instanceof ImmutableGraphSchema) {
            return (ImmutableGraphSchema)instance;
        }
        return ImmutableGraphSchema.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphSchema", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NODE_SCHEMA = 1L;
        private static final long INIT_BIT_RELATIONSHIP_SCHEMA = 2L;
        private long initBits = 3L;
        private NodeSchema nodeSchema;
        private RelationshipSchema relationshipSchema;

        private Builder() {
        }

        public final Builder from(GraphSchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.nodeSchema(instance.nodeSchema());
            this.relationshipSchema(instance.relationshipSchema());
            return this;
        }

        public final Builder nodeSchema(NodeSchema nodeSchema) {
            this.nodeSchema = Objects.requireNonNull(nodeSchema, "nodeSchema");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipSchema(RelationshipSchema relationshipSchema) {
            this.relationshipSchema = Objects.requireNonNull(relationshipSchema, "relationshipSchema");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.nodeSchema = null;
            this.relationshipSchema = null;
            return this;
        }

        public GraphSchema build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphSchema(null, this.nodeSchema, this.relationshipSchema);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nodeSchema");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relationshipSchema");
            }
            return "Cannot build GraphSchema, some of required attributes are not set " + attributes;
        }
    }
}

