/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.schema.ImmutableGraphSchema;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.api.schema.PropertySchema;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.api.schema.RelationshipSchema;

@ValueClass
public interface GraphSchema {
    public NodeSchema nodeSchema();

    public RelationshipSchema relationshipSchema();

    default public Map<String, Object> toMap() {
        return Map.of("nodes", this.nodeSchema().toMap(), "relationships", this.relationshipSchema().toMap());
    }

    default public GraphSchema filterNodeLabels(Set<NodeLabel> labelsToKeep) {
        return GraphSchema.of((NodeSchema)this.nodeSchema().filter((Set)labelsToKeep), this.relationshipSchema());
    }

    default public GraphSchema filterRelationshipTypes(Set<RelationshipType> relationshipTypesToKeep) {
        return GraphSchema.of(this.nodeSchema(), (RelationshipSchema)this.relationshipSchema().filter((Set)relationshipTypesToKeep));
    }

    default public GraphSchema union(GraphSchema other) {
        return GraphSchema.of(this.nodeSchema().union(other.nodeSchema()), this.relationshipSchema().union(other.relationshipSchema()));
    }

    public static GraphSchema of(NodeSchema nodeSchema, RelationshipSchema relationshipSchema) {
        return ImmutableGraphSchema.builder().nodeSchema(nodeSchema).relationshipSchema(relationshipSchema).build();
    }

    public static <PS extends PropertySchema> String forPropertySchema(PS propertySchema) {
        if (propertySchema instanceof RelationshipPropertySchema) {
            return String.format(Locale.ENGLISH, "%s (%s, %s, Aggregation.%s)", new Object[]{propertySchema.valueType().cypherName(), propertySchema.defaultValue(), propertySchema.state(), ((RelationshipPropertySchema)propertySchema).aggregation()});
        }
        return String.format(Locale.ENGLISH, "%s (%s, %s)", new Object[]{propertySchema.valueType().cypherName(), propertySchema.defaultValue(), propertySchema.state()});
    }

    public static GraphSchema empty() {
        return GraphSchema.of(NodeSchema.of(Map.of()), RelationshipSchema.of(Map.of()));
    }
}

