/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.api.schema.PropertySchema;

public interface ElementSchema<SELF extends ElementSchema<SELF, ELEMENT_IDENTIFIER, PROPERTY_SCHEMA>, ELEMENT_IDENTIFIER extends ElementIdentifier, PROPERTY_SCHEMA extends PropertySchema> {
    public Map<ELEMENT_IDENTIFIER, Map<String, PROPERTY_SCHEMA>> properties();

    public SELF filter(Set<ELEMENT_IDENTIFIER> var1);

    public SELF union(SELF var1);

    @Value.Derived
    default public Set<String> allProperties() {
        return this.properties().values().stream().flatMap(propertyMapping -> propertyMapping.keySet().stream()).collect(Collectors.toSet());
    }

    @Value.Derived
    default public boolean hasProperties() {
        return !this.allProperties().isEmpty();
    }

    @Value.Default
    default public boolean hasProperties(ELEMENT_IDENTIFIER elementIdentifier) {
        return !this.properties().get(elementIdentifier).isEmpty();
    }

    @Value.Default
    default public List<PROPERTY_SCHEMA> propertySchemasFor(ELEMENT_IDENTIFIER elementIdentifier) {
        SELF propertySchemaForTypes = this.filter(Set.of(elementIdentifier));
        return new ArrayList<PROPERTY_SCHEMA>(propertySchemaForTypes.unionProperties().values());
    }

    @Value.Derived
    default public Map<String, Object> toMap() {
        return this.properties().entrySet().stream().collect(Collectors.toMap(entry -> ((ElementIdentifier)entry.getKey()).name, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, innerEntry -> GraphSchema.forPropertySchema((PropertySchema)innerEntry.getValue())))));
    }

    @Value.Derived
    default public Map<ELEMENT_IDENTIFIER, Map<String, PROPERTY_SCHEMA>> filterProperties(Set<ELEMENT_IDENTIFIER> identifiersToKeep) {
        return this.properties().entrySet().stream().filter((? super T entry) -> identifiersToKeep.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Value.Lazy
    default public Map<String, PROPERTY_SCHEMA> unionProperties() {
        return this.properties().values().stream().flatMap(e -> e.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (leftSchema, rightSchema) -> {
            if (leftSchema.valueType() != rightSchema.valueType()) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Combining schema entries with value type %s and %s is not supported.", leftSchema.valueType(), rightSchema.valueType()));
            }
            return leftSchema;
        }));
    }

    default public Map<ELEMENT_IDENTIFIER, Map<String, PROPERTY_SCHEMA>> unionSchema(Map<ELEMENT_IDENTIFIER, Map<String, PROPERTY_SCHEMA>> rightProperties) {
        return Stream.concat(this.properties().entrySet().stream(), rightProperties.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (left, right) -> Stream.concat(left.entrySet().stream(), right.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (leftType, rightType) -> {
            if (leftType.valueType() != rightType.valueType()) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Combining schema entries with value type %s and %s is not supported.", left.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((PropertySchema)entry.getValue()).valueType())), right.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((PropertySchema)entry.getValue()).valueType()))));
            }
            return leftType;
        }))));
    }
}

