/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import org.neo4j.gds.utils.StringFormatting;

public final class ValueConversion {
    private ValueConversion() {
    }

    public static long exactDoubleToLong(double d) {
        if (d % 1.0 == 0.0) {
            return (long)d;
        }
        throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Cannot safely convert %.2f into an long value", (Object[])new Object[]{d}));
    }

    public static double exactLongToDouble(long l) {
        if (l <= 0x20000000000000L) {
            return l;
        }
        throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Cannot safely convert %d into an double value", (Object[])new Object[]{l}));
    }

    public static float exactLongToFloat(long l) {
        if (l >= 0x1000000L || l <= -16777216L) {
            throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Cannot safely convert %d into a float value", (Object[])new Object[]{l}));
        }
        return l;
    }

    public static float notOverflowingDoubleToFloat(double d) {
        if (d > 3.4028234663852886E38 || d < -3.4028234663852886E38) {
            throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Cannot safely convert %.2f into a float value", (Object[])new Object[]{d}));
        }
        return (float)d;
    }
}

