/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.utils.StringFormatting;

public final class DefaultValueUtil {
    private DefaultValueUtil() {
    }

    static Object transformObjectToPrimitiveArray(Object[] defaultArrayValue) {
        if (defaultArrayValue.length == 0) {
            return defaultArrayValue;
        }
        Object firstEntry = defaultArrayValue[0];
        if (firstEntry instanceof Double) {
            return DefaultValueUtil.parseDoubleArrayValue(defaultArrayValue, ValueType.DOUBLE_ARRAY);
        }
        if (firstEntry instanceof Float) {
            return DefaultValueUtil.parseFloatArrayValue(defaultArrayValue, ValueType.FLOAT_ARRAY);
        }
        if (firstEntry instanceof Long || firstEntry instanceof Integer) {
            return DefaultValueUtil.parseLongArrayValue(defaultArrayValue, ValueType.LONG_ARRAY);
        }
        throw new IllegalStateException("Unexpected type of array " + firstEntry.getClass().getSimpleName());
    }

    static double[] parseDoubleArrayValue(Object defaultValue, ValueType type) {
        double[] defaultDoubleArray;
        if (defaultValue instanceof Collection) {
            defaultDoubleArray = ((Collection)defaultValue).stream().map(Object::toString).mapToDouble(Double::parseDouble).toArray();
        } else if (defaultValue instanceof Object[]) {
            Object[] objectArray = (Object[])defaultValue;
            defaultDoubleArray = Arrays.stream(objectArray).map(Object::toString).mapToDouble(Double::parseDouble).toArray();
        } else {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot create default value of type `%s` from input value %s", (Object[])new Object[]{type.toString(), defaultValue.getClass().getSimpleName()}));
        }
        return defaultDoubleArray;
    }

    static long[] parseLongArrayValue(Object defaultValue, ValueType type) {
        long[] defaultLongArray;
        if (defaultValue instanceof Collection) {
            defaultLongArray = ((Collection)defaultValue).stream().map(Object::toString).mapToLong(Long::parseLong).toArray();
        } else if (defaultValue instanceof Object[]) {
            Object[] objectArray = (Object[])defaultValue;
            defaultLongArray = Arrays.stream(objectArray).map(Object::toString).mapToLong(Long::parseLong).toArray();
        } else {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot create default value of type `%s` from input value %s", (Object[])new Object[]{type.toString(), defaultValue.getClass().getSimpleName()}));
        }
        return defaultLongArray;
    }

    static float[] parseFloatArrayValue(Object defaultValue, ValueType type) {
        float[] defaultFloatArray;
        if (defaultValue instanceof List) {
            List df = (List)defaultValue;
            defaultFloatArray = new float[df.size()];
            for (int i = 0; i < df.size(); ++i) {
                defaultFloatArray[i] = Float.parseFloat(df.get(i).toString());
            }
        } else if (defaultValue instanceof Object[]) {
            Object[] objectArray = (Object[])defaultValue;
            defaultFloatArray = new float[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                defaultFloatArray[i] = Float.parseFloat(objectArray[i].toString());
            }
        } else {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot create default value of type `%s` from input value %s", (Object[])new Object[]{type.toString(), defaultValue.getClass().getSimpleName()}));
        }
        return defaultFloatArray;
    }
}

