/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.DefaultValueUtil;
import org.neo4j.gds.api.ValueConversion;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.utils.StringFormatting;

public final class DefaultValue {
    public static final DefaultValue DEFAULT = DefaultValue.ofFallBackValue(null);
    public static final int INTEGER_DEFAULT_FALLBACK = Integer.MIN_VALUE;
    public static final long LONG_DEFAULT_FALLBACK = Long.MIN_VALUE;
    public static final float FLOAT_DEFAULT_FALLBACK = Float.NaN;
    public static final double DOUBLE_DEFAULT_FALLBACK = Double.NaN;
    private static final double[] DOUBLE_ARRAY_DEFAULT_FALLBACK = DEFAULT.doubleArrayValue();
    private static final long[] LONG_ARRAY_DEFAULT_FALLBACK = DEFAULT.longArrayValue();
    private static final float[] FLOAT_ARRAY_DEFAULT_FALLBACK = DEFAULT.floatArrayValue();
    @Nullable
    private final Object defaultValue;
    private final boolean isUserDefined;

    public static DefaultValue of(Object defaultValue) {
        return DefaultValue.of(defaultValue, true);
    }

    public static DefaultValue of(@Nullable Object defaultValue, boolean isUserDefined) {
        if (defaultValue instanceof DefaultValue) {
            return (DefaultValue)defaultValue;
        }
        if (defaultValue instanceof List) {
            Object primitiveArray = DefaultValueUtil.transformObjectToPrimitiveArray(((List)defaultValue).toArray());
            return new DefaultValue(primitiveArray, isUserDefined);
        }
        return new DefaultValue(defaultValue, isUserDefined);
    }

    public static DefaultValue of(@Nullable Object defaultValue, ValueType type, boolean isUserDefined) {
        if (defaultValue == null || defaultValue.toString().isBlank()) {
            return type.fallbackValue();
        }
        switch (type) {
            case LONG: {
                return DefaultValue.of(Long.parseLong(defaultValue.toString()), isUserDefined);
            }
            case DOUBLE: {
                return DefaultValue.of(Double.parseDouble(defaultValue.toString()), isUserDefined);
            }
            case DOUBLE_ARRAY: {
                return DefaultValue.of(DefaultValueUtil.parseDoubleArrayValue(defaultValue, type), isUserDefined);
            }
            case LONG_ARRAY: {
                return DefaultValue.of(DefaultValueUtil.parseLongArrayValue(defaultValue, type), isUserDefined);
            }
            case FLOAT_ARRAY: {
                return DefaultValue.of(DefaultValueUtil.parseFloatArrayValue(defaultValue, type), isUserDefined);
            }
        }
        return DefaultValue.of(defaultValue, isUserDefined);
    }

    private static DefaultValue ofFallBackValue(@Nullable Object defaultValue) {
        return DefaultValue.of(defaultValue, false);
    }

    public static DefaultValue forInt() {
        return DefaultValue.ofFallBackValue(Integer.MIN_VALUE);
    }

    public static DefaultValue forLong() {
        return DefaultValue.ofFallBackValue(Long.MIN_VALUE);
    }

    public static DefaultValue forDouble() {
        return DefaultValue.ofFallBackValue(Double.NaN);
    }

    public static DefaultValue forFloat() {
        return DefaultValue.ofFallBackValue(Float.valueOf(Float.NaN));
    }

    public static DefaultValue forLongArray() {
        return DefaultValue.ofFallBackValue(LONG_ARRAY_DEFAULT_FALLBACK);
    }

    public static DefaultValue forFloatArray() {
        return DefaultValue.ofFallBackValue(FLOAT_ARRAY_DEFAULT_FALLBACK);
    }

    public static DefaultValue forDoubleArray() {
        return DefaultValue.ofFallBackValue(DOUBLE_ARRAY_DEFAULT_FALLBACK);
    }

    private DefaultValue(@Nullable Object defaultValue, boolean isUserDefined) {
        this.defaultValue = defaultValue;
        this.isUserDefined = isUserDefined;
    }

    public boolean isUserDefined() {
        return this.isUserDefined;
    }

    public long longValue() {
        if (this.defaultValue == null) {
            return Long.MIN_VALUE;
        }
        if (this.defaultValue instanceof Double && Double.isNaN((Double)this.defaultValue)) {
            return Long.MIN_VALUE;
        }
        if (this.defaultValue instanceof Float && Float.isNaN(((Float)this.defaultValue).floatValue())) {
            return Long.MIN_VALUE;
        }
        if (this.defaultValue instanceof Double || this.defaultValue instanceof Float) {
            return ValueConversion.exactDoubleToLong(((Number)this.defaultValue).doubleValue());
        }
        if (this.defaultValue instanceof Number) {
            return ((Number)this.defaultValue).longValue();
        }
        throw this.getInvalidTypeException(Long.class);
    }

    public double doubleValue() {
        if (this.defaultValue instanceof Long && this.defaultValue.equals(Long.MIN_VALUE)) {
            return Double.NaN;
        }
        if (this.defaultValue instanceof Long || this.defaultValue instanceof Integer) {
            return ValueConversion.exactLongToDouble(((Number)this.defaultValue).longValue());
        }
        if (this.defaultValue instanceof Number) {
            return ((Number)this.defaultValue).doubleValue();
        }
        if (this.defaultValue == null) {
            return Double.NaN;
        }
        throw this.getInvalidTypeException(Double.class);
    }

    public float[] floatArrayValue() {
        float[] floatArray = null;
        if (this.defaultValue == null) {
            return null;
        }
        if (this.defaultValue instanceof float[]) {
            return (float[])this.defaultValue;
        }
        if (this.defaultValue instanceof double[]) {
            double[] doubleArray = (double[])this.defaultValue;
            floatArray = new float[doubleArray.length];
            for (int i = 0; i < doubleArray.length; ++i) {
                floatArray[i] = ValueConversion.notOverflowingDoubleToFloat(doubleArray[i]);
            }
        } else if (this.defaultValue instanceof long[]) {
            long[] longArray = (long[])this.defaultValue;
            floatArray = new float[longArray.length];
            for (int i = 0; i < longArray.length; ++i) {
                floatArray[i] = ValueConversion.exactLongToFloat(longArray[i]);
            }
        } else {
            throw this.getInvalidTypeException(float[].class);
        }
        return floatArray;
    }

    public double[] doubleArrayValue() {
        double[] doubleArray = null;
        if (this.defaultValue == null) {
            return null;
        }
        if (this.defaultValue instanceof double[]) {
            return (double[])this.defaultValue;
        }
        if (this.defaultValue instanceof float[]) {
            float[] floatArray = (float[])this.defaultValue;
            doubleArray = new double[floatArray.length];
            for (int i = 0; i < floatArray.length; ++i) {
                doubleArray[i] = floatArray[i];
            }
        } else if (this.defaultValue instanceof long[]) {
            long[] longArray = (long[])this.defaultValue;
            doubleArray = new double[longArray.length];
            for (int i = 0; i < longArray.length; ++i) {
                doubleArray[i] = ValueConversion.exactLongToDouble(longArray[i]);
            }
        } else {
            throw this.getInvalidTypeException(double[].class);
        }
        return doubleArray;
    }

    public long[] longArrayValue() {
        long[] longArray = null;
        if (this.defaultValue == null) {
            return null;
        }
        if (this.defaultValue instanceof long[]) {
            return (long[])this.defaultValue;
        }
        if (this.defaultValue instanceof float[]) {
            float[] floatArray = (float[])this.defaultValue;
            longArray = new long[floatArray.length];
            for (int i = 0; i < floatArray.length; ++i) {
                longArray[i] = ValueConversion.exactDoubleToLong(floatArray[i]);
            }
        } else if (this.defaultValue instanceof double[]) {
            double[] doubleArray = (double[])this.defaultValue;
            longArray = new long[doubleArray.length];
            for (int i = 0; i < doubleArray.length; ++i) {
                longArray[i] = ValueConversion.exactDoubleToLong(doubleArray[i]);
            }
        } else {
            throw this.getInvalidTypeException(long[].class);
        }
        return longArray;
    }

    @Nullable
    public Object getObject() {
        return this.defaultValue;
    }

    public String toString() {
        return "DefaultValue(" + this.defaultValue + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultValue that = (DefaultValue)o;
        return Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue);
    }

    @NotNull
    private IllegalArgumentException getInvalidTypeException(Class<?> expectedClass) {
        return new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected type of default value to be `%s`. But got `%s`.", (Object[])new Object[]{expectedClass.getSimpleName(), this.defaultValue.getClass().getSimpleName()}));
    }
}

