/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.AbstractRelationshipProjection;
import org.neo4j.gds.ElementProjection;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.core.Aggregation;

@Generated(from="AbstractRelationshipProjection", generator="Immutables")
public final class RelationshipProjection
extends AbstractRelationshipProjection {
    private final String type;
    private final Orientation orientation;
    private final Aggregation aggregation;
    private final PropertyMappings properties;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private RelationshipProjection(String type, Orientation orientation, Aggregation aggregation) {
        this.type = Objects.requireNonNull(type, "type");
        this.initShim.orientation(Objects.requireNonNull(orientation, "orientation"));
        this.initShim.aggregation(Objects.requireNonNull(aggregation, "aggregation"));
        this.orientation = this.initShim.orientation();
        this.aggregation = this.initShim.aggregation();
        this.properties = this.initShim.properties();
        this.initShim = null;
    }

    private RelationshipProjection(Builder builder) {
        this.type = builder.type;
        if (builder.orientation != null) {
            this.initShim.orientation(builder.orientation);
        }
        if (builder.aggregation != null) {
            this.initShim.aggregation(builder.aggregation);
        }
        if (builder.properties != null) {
            this.initShim.properties(builder.properties);
        }
        this.orientation = this.initShim.orientation();
        this.aggregation = this.initShim.aggregation();
        this.properties = this.initShim.properties();
        this.initShim = null;
    }

    private RelationshipProjection(String type, Orientation orientation, Aggregation aggregation, PropertyMappings properties) {
        this.type = type;
        this.orientation = orientation;
        this.aggregation = aggregation;
        this.properties = properties;
        this.initShim = null;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public Orientation orientation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.orientation() : this.orientation;
    }

    @Override
    public Aggregation aggregation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.aggregation() : this.aggregation;
    }

    @Override
    public PropertyMappings properties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.properties() : this.properties;
    }

    public final RelationshipProjection withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new RelationshipProjection(newValue, this.orientation, this.aggregation, this.properties);
    }

    public final RelationshipProjection withOrientation(Orientation value) {
        if (this.orientation == value) {
            return this;
        }
        Orientation newValue = Objects.requireNonNull(value, "orientation");
        if (this.orientation.equals((Object)newValue)) {
            return this;
        }
        return new RelationshipProjection(this.type, newValue, this.aggregation, this.properties);
    }

    public final RelationshipProjection withAggregation(Aggregation value) {
        if (this.aggregation == value) {
            return this;
        }
        Aggregation newValue = Objects.requireNonNull(value, "aggregation");
        if (this.aggregation.equals((Object)newValue)) {
            return this;
        }
        return new RelationshipProjection(this.type, this.orientation, newValue, this.properties);
    }

    public final RelationshipProjection withProperties(PropertyMappings value) {
        if (this.properties == value) {
            return this;
        }
        PropertyMappings newValue = Objects.requireNonNull(value, "properties");
        return new RelationshipProjection(this.type, this.orientation, this.aggregation, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RelationshipProjection && this.equalTo((RelationshipProjection)another);
    }

    private boolean equalTo(RelationshipProjection another) {
        return this.type.equals(another.type) && this.orientation.equals((Object)another.orientation) && this.aggregation.equals((Object)another.aggregation) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.orientation.hashCode();
        h += (h << 5) + this.aggregation.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "RelationshipProjection{type=" + this.type + ", orientation=" + this.orientation + ", aggregation=" + this.aggregation + ", properties=" + this.properties + "}";
    }

    public static RelationshipProjection of(String type, Orientation orientation, Aggregation aggregation) {
        return new RelationshipProjection(type, orientation, aggregation);
    }

    public static RelationshipProjection copyOf(AbstractRelationshipProjection instance) {
        if (instance instanceof RelationshipProjection) {
            return (RelationshipProjection)instance;
        }
        return new AbstractRelationshipProjection.Builder().from(instance).build();
    }

    @Generated(from="AbstractRelationshipProjection", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        protected String type;
        protected Orientation orientation;
        protected Aggregation aggregation;
        protected PropertyMappings properties;

        public Builder() {
            if (!(this instanceof AbstractRelationshipProjection.Builder)) {
                throw new UnsupportedOperationException("Use: new AbstractRelationshipProjection.Builder()");
            }
        }

        public final AbstractRelationshipProjection.Builder from(ElementProjection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (AbstractRelationshipProjection.Builder)this;
        }

        public final AbstractRelationshipProjection.Builder from(AbstractRelationshipProjection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (AbstractRelationshipProjection.Builder)this;
        }

        private void from(Object object) {
            ElementProjection instance;
            long bits = 0L;
            if (object instanceof ElementProjection) {
                instance = (ElementProjection)object;
                if ((bits & 1L) == 0L) {
                    this.properties(instance.properties());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractRelationshipProjection) {
                instance = (AbstractRelationshipProjection)object;
                this.orientation(((AbstractRelationshipProjection)instance).orientation());
                this.aggregation(((AbstractRelationshipProjection)instance).aggregation());
                this.type(((AbstractRelationshipProjection)instance).type());
                if ((bits & 1L) == 0L) {
                    this.properties(((AbstractRelationshipProjection)instance).properties());
                    bits |= 1L;
                }
            }
        }

        public final AbstractRelationshipProjection.Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (AbstractRelationshipProjection.Builder)this;
        }

        public final AbstractRelationshipProjection.Builder orientation(Orientation orientation) {
            this.orientation = Objects.requireNonNull(orientation, "orientation");
            return (AbstractRelationshipProjection.Builder)this;
        }

        public final AbstractRelationshipProjection.Builder aggregation(Aggregation aggregation) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
            return (AbstractRelationshipProjection.Builder)this;
        }

        public final AbstractRelationshipProjection.Builder properties(PropertyMappings properties) {
            this.properties = Objects.requireNonNull(properties, "properties");
            return (AbstractRelationshipProjection.Builder)this;
        }

        public AbstractRelationshipProjection.Builder clear() {
            this.initBits = 1L;
            this.type = null;
            this.orientation = null;
            this.aggregation = null;
            this.properties = null;
            return (AbstractRelationshipProjection.Builder)this;
        }

        public RelationshipProjection build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RelationshipProjection(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build RelationshipProjection, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="AbstractRelationshipProjection", generator="Immutables")
    private final class InitShim {
        private byte orientationBuildStage = 0;
        private Orientation orientation;
        private byte aggregationBuildStage = 0;
        private Aggregation aggregation;
        private byte propertiesBuildStage = 0;
        private PropertyMappings properties;

        private InitShim() {
        }

        Orientation orientation() {
            if (this.orientationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.orientationBuildStage == 0) {
                this.orientationBuildStage = (byte)-1;
                this.orientation = Objects.requireNonNull(RelationshipProjection.super.orientation(), "orientation");
                this.orientationBuildStage = 1;
            }
            return this.orientation;
        }

        void orientation(Orientation orientation) {
            this.orientation = orientation;
            this.orientationBuildStage = 1;
        }

        Aggregation aggregation() {
            if (this.aggregationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aggregationBuildStage == 0) {
                this.aggregationBuildStage = (byte)-1;
                this.aggregation = Objects.requireNonNull(RelationshipProjection.super.aggregation(), "aggregation");
                this.aggregationBuildStage = 1;
            }
            return this.aggregation;
        }

        void aggregation(Aggregation aggregation) {
            this.aggregation = aggregation;
            this.aggregationBuildStage = 1;
        }

        PropertyMappings properties() {
            if (this.propertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertiesBuildStage == 0) {
                this.propertiesBuildStage = (byte)-1;
                this.properties = Objects.requireNonNull(RelationshipProjection.super.properties(), "properties");
                this.propertiesBuildStage = 1;
            }
            return this.properties;
        }

        void properties(PropertyMappings properties) {
            this.properties = properties;
            this.propertiesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.orientationBuildStage == -1) {
                attributes.add("orientation");
            }
            if (this.aggregationBuildStage == -1) {
                attributes.add("aggregation");
            }
            if (this.propertiesBuildStage == -1) {
                attributes.add("properties");
            }
            return "Cannot build RelationshipProjection, attribute initializers form cycle " + attributes;
        }
    }
}

