/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.AbstractPropertyMappings;
import org.neo4j.gds.ImmutablePropertyMapping;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.core.Aggregation;

@Generated(from="AbstractPropertyMappings", generator="Immutables")
public final class PropertyMappings
extends AbstractPropertyMappings {
    private final List<PropertyMapping> mappings;
    private static final PropertyMappings INSTANCE = PropertyMappings.validate(new PropertyMappings());

    private PropertyMappings() {
        this.mappings = Collections.emptyList();
    }

    private PropertyMappings(Iterable<? extends PropertyMapping> mappings) {
        this.mappings = PropertyMappings.createUnmodifiableList(false, PropertyMappings.createSafeList(mappings, true, false));
    }

    private PropertyMappings(PropertyMappings original, List<PropertyMapping> mappings) {
        this.mappings = mappings;
    }

    @Override
    public List<PropertyMapping> mappings() {
        return this.mappings;
    }

    public final PropertyMappings withMappings(PropertyMapping ... elements) {
        List<PropertyMapping> newValue = PropertyMappings.createUnmodifiableList(false, PropertyMappings.createSafeList(Arrays.asList(elements), true, false));
        return PropertyMappings.validate(new PropertyMappings(this, newValue));
    }

    public final PropertyMappings withMappings(Iterable<? extends PropertyMapping> elements) {
        if (this.mappings == elements) {
            return this;
        }
        List<PropertyMapping> newValue = PropertyMappings.createUnmodifiableList(false, PropertyMappings.createSafeList(elements, true, false));
        return PropertyMappings.validate(new PropertyMappings(this, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PropertyMappings && this.equalTo((PropertyMappings)another);
    }

    private boolean equalTo(PropertyMappings another) {
        return this.mappings.equals(another.mappings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mappings.hashCode();
        return h;
    }

    public String toString() {
        return "PropertyMappings{mappings=" + this.mappings + "}";
    }

    public static PropertyMappings of() {
        return INSTANCE;
    }

    public static PropertyMappings of(List<PropertyMapping> mappings) {
        return PropertyMappings.of(mappings);
    }

    public static PropertyMappings of(Iterable<? extends PropertyMapping> mappings) {
        return PropertyMappings.validate(new PropertyMappings(mappings));
    }

    private static PropertyMappings validate(PropertyMappings instance) {
        instance.checkForAggregationMixing();
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static PropertyMappings copyOf(AbstractPropertyMappings instance) {
        if (instance instanceof PropertyMappings) {
            return (PropertyMappings)instance;
        }
        return new AbstractPropertyMappings.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractPropertyMappings", generator="Immutables")
    public static class Builder {
        protected List<PropertyMapping> mappings = null;

        public Builder() {
            if (!(this instanceof AbstractPropertyMappings.Builder)) {
                throw new UnsupportedOperationException("Use: new AbstractPropertyMappings.Builder()");
            }
        }

        public final AbstractPropertyMappings.Builder from(AbstractPropertyMappings instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllMappings(instance.mappings());
            return (AbstractPropertyMappings.Builder)this;
        }

        public final AbstractPropertyMappings.Builder addMapping(PropertyMapping element) {
            if (this.mappings == null) {
                this.mappings = new ArrayList<PropertyMapping>();
            }
            element = ImmutablePropertyMapping.copyOf(element);
            this.mappings.add(Objects.requireNonNull(element, "mappings element"));
            return (AbstractPropertyMappings.Builder)this;
        }

        public final AbstractPropertyMappings.Builder addMapping(@Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
            return this.addMapping(ImmutablePropertyMapping.of(propertyKey, neoPropertyKey, defaultValue, aggregation));
        }

        public final AbstractPropertyMappings.Builder addMappings(PropertyMapping ... elements) {
            if (this.mappings == null) {
                this.mappings = new ArrayList<PropertyMapping>();
            }
            for (PropertyMapping element : elements) {
                element = ImmutablePropertyMapping.copyOf(element);
                this.mappings.add(Objects.requireNonNull(element, "mappings element"));
            }
            return (AbstractPropertyMappings.Builder)this;
        }

        public final AbstractPropertyMappings.Builder mappings(Iterable<? extends PropertyMapping> elements) {
            this.mappings = new ArrayList<PropertyMapping>();
            return this.addAllMappings(elements);
        }

        public final AbstractPropertyMappings.Builder addAllMappings(Iterable<? extends PropertyMapping> elements) {
            Objects.requireNonNull(elements, "mappings element");
            if (this.mappings == null) {
                this.mappings = new ArrayList<PropertyMapping>();
            }
            for (PropertyMapping propertyMapping : elements) {
                PropertyMapping propertyMapping2 = ImmutablePropertyMapping.copyOf(propertyMapping);
                this.mappings.add(Objects.requireNonNull(propertyMapping2, "mappings element"));
            }
            return (AbstractPropertyMappings.Builder)this;
        }

        public AbstractPropertyMappings.Builder clear() {
            if (this.mappings != null) {
                this.mappings.clear();
            }
            return (AbstractPropertyMappings.Builder)this;
        }

        public PropertyMappings build() {
            return PropertyMappings.validate(new PropertyMappings(null, this.mappings == null ? Collections.emptyList() : PropertyMappings.createUnmodifiableList(true, this.mappings)));
        }
    }
}

