/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ImmutablePropertyMapping;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
public abstract class PropertyMapping {
    public static final String PROPERTY_KEY = "property";
    public static final String DEFAULT_VALUE_KEY = "defaultValue";

    @Nullable
    public abstract String propertyKey();

    @Value.Default
    @Nullable
    public String neoPropertyKey() {
        return this.propertyKey();
    }

    @Value.Default
    public DefaultValue defaultValue() {
        return DefaultValue.DEFAULT;
    }

    @Value.Default
    public Aggregation aggregation() {
        return Aggregation.DEFAULT;
    }

    @Value.Check
    public void validateProperties() {
        if (this.neoPropertyKey().equals("*") && this.aggregation() != Aggregation.COUNT) {
            throw new IllegalArgumentException("A '*' property key can only be used in combination with count aggregation.");
        }
    }

    public static PropertyMapping fromObject(String propertyKey, Object stringOrMap) {
        if (stringOrMap instanceof String) {
            String neoPropertyKey = (String)stringOrMap;
            return PropertyMapping.fromObject(propertyKey, Collections.singletonMap(PROPERTY_KEY, neoPropertyKey));
        }
        if (stringOrMap instanceof Map) {
            Aggregation aggregation;
            Map propertyMap = (Map)stringOrMap;
            String propertyNameValue = propertyMap.getOrDefault(PROPERTY_KEY, propertyKey);
            if (!(propertyNameValue instanceof String)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected the value of '%s' to be of type String, but was '%s'.", (Object[])new Object[]{PROPERTY_KEY, propertyNameValue.getClass().getSimpleName()}));
            }
            String neoPropertyKey = propertyNameValue;
            Object aggregationValue = propertyMap.get("aggregation");
            if (aggregationValue == null) {
                aggregation = Aggregation.DEFAULT;
            } else if (aggregationValue instanceof String) {
                aggregation = Aggregation.parse(aggregationValue);
            } else {
                throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Expected the value of '%s' to be of type String, but was '%s'", (Object[])new Object[]{"aggregation", aggregationValue.getClass().getSimpleName()}));
            }
            Object defaultValue = propertyMap.get(DEFAULT_VALUE_KEY);
            boolean isUserDefined = propertyMap.containsKey(DEFAULT_VALUE_KEY);
            return PropertyMapping.of(propertyKey, neoPropertyKey, DefaultValue.of(defaultValue, isUserDefined), aggregation);
        }
        throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Expected stringOrMap to be of type String or Map, but got %s", (Object[])new Object[]{stringOrMap.getClass().getSimpleName()}));
    }

    public boolean hasValidName() {
        String key = this.neoPropertyKey();
        return key != null && !key.isEmpty();
    }

    public boolean exists() {
        return false;
    }

    public Map.Entry<String, Object> toObject(boolean includeAggregation) {
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        value.put(PROPERTY_KEY, this.neoPropertyKey());
        value.put(DEFAULT_VALUE_KEY, this.defaultValue().getObject());
        if (includeAggregation) {
            value.put("aggregation", this.aggregation().name());
        }
        return new AbstractMap.SimpleImmutableEntry<String, Object>(this.propertyKey(), value);
    }

    public PropertyMapping setNonDefaultAggregation(Aggregation aggregation) {
        if (aggregation == Aggregation.DEFAULT || this.aggregation() != Aggregation.DEFAULT) {
            return this;
        }
        return ((ImmutablePropertyMapping)this).withAggregation(aggregation);
    }

    public static PropertyMapping of(String propertyKey) {
        return ImmutablePropertyMapping.builder().propertyKey(propertyKey).build();
    }

    public static PropertyMapping of(String neoPropertyKey, Object defaultValue) {
        return ImmutablePropertyMapping.builder().propertyKey(neoPropertyKey).defaultValue(DefaultValue.of(defaultValue)).build();
    }

    public static PropertyMapping of(String propertyKey, String neoPropertyKey, Object defaultValue) {
        return ImmutablePropertyMapping.builder().propertyKey(propertyKey).neoPropertyKey(neoPropertyKey).defaultValue(DefaultValue.of(defaultValue)).build();
    }

    public static PropertyMapping of(String propertyKey, DefaultValue defaultValue, Aggregation aggregation) {
        return ImmutablePropertyMapping.builder().propertyKey(propertyKey).defaultValue(defaultValue).aggregation(aggregation).build();
    }

    public static PropertyMapping of(String propertyKey, Aggregation aggregation) {
        return ImmutablePropertyMapping.builder().propertyKey(propertyKey).aggregation(aggregation).build();
    }

    public static PropertyMapping of(String propertyKey, String neoPropertyKey, Aggregation aggregation) {
        return ImmutablePropertyMapping.builder().propertyKey(propertyKey).neoPropertyKey(neoPropertyKey).aggregation(aggregation).build();
    }

    public static PropertyMapping of(String propertyKey, String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
        return ImmutablePropertyMapping.of(propertyKey, neoPropertyKey, defaultValue, aggregation);
    }
}

