/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.utils.StringFormatting;

public abstract class ElementIdentifier {
    @NotNull
    public final String name;

    ElementIdentifier(@NotNull String name) {
        if (name.equals("*")) {
            throw new IllegalArgumentException("name cannot be `*`");
        }
        if (StringFormatting.isEmpty((String)name)) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public abstract ElementIdentifier projectAll();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementIdentifier that = (ElementIdentifier)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return StringFormatting.formatWithLocale((String)("%s{name='" + this.name + "'}"), (Object[])new Object[]{this.getClass().getSimpleName()});
    }
}

