/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ElementProjection;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.DataClass;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.ConfigKeyValidation;
import org.neo4j.gds.utils.StringFormatting;

@DataClass
public abstract class AbstractRelationshipProjection
extends ElementProjection {
    public static final RelationshipProjection ALL = AbstractRelationshipProjection.of("*", Orientation.NATURAL);
    public static final RelationshipProjection ALL_UNDIRECTED = AbstractRelationshipProjection.of("*", Orientation.UNDIRECTED);
    public static final String TYPE_KEY = "type";
    public static final String ORIENTATION_KEY = "orientation";
    public static final String AGGREGATION_KEY = "aggregation";

    public abstract String type();

    @Value.Default
    public Orientation orientation() {
        return Orientation.NATURAL;
    }

    @Value.Default
    public Aggregation aggregation() {
        return Aggregation.DEFAULT;
    }

    @Override
    @Value.Default
    @Value.Parameter(value=false)
    public PropertyMappings properties() {
        return super.properties();
    }

    @Override
    public boolean projectAll() {
        return this.type().equals("*");
    }

    public static RelationshipProjection fromMap(Map<String, Object> map, RelationshipType relationshipType) {
        Builder builder = RelationshipProjection.builder();
        String type = String.valueOf(map.getOrDefault(TYPE_KEY, relationshipType.name));
        AbstractRelationshipProjection.validateConfigKeys(map);
        builder.type(type);
        if (map.containsKey(ORIENTATION_KEY)) {
            builder.orientation(Orientation.parse(AbstractRelationshipProjection.nonEmptyString(map, ORIENTATION_KEY)));
        }
        if (map.containsKey(AGGREGATION_KEY)) {
            Aggregation aggregation = Aggregation.parse(AbstractRelationshipProjection.nonEmptyString(map, AGGREGATION_KEY));
            builder.aggregation(aggregation);
            return AbstractRelationshipProjection.create(map, aggregation, properties -> builder.properties((PropertyMappings)properties).build());
        }
        return AbstractRelationshipProjection.create(map, properties -> builder.properties((PropertyMappings)properties).build());
    }

    public static RelationshipProjection fromString(@Nullable String type) {
        return RelationshipProjection.builder().type(type).build();
    }

    public static RelationshipProjection fromObject(Object object, RelationshipType relationshipType) {
        if (object == null) {
            return AbstractRelationshipProjection.all();
        }
        if (object instanceof String) {
            return AbstractRelationshipProjection.fromString((String)object);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return AbstractRelationshipProjection.fromMap(map, relationshipType);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot construct a relationship filter out of a %s", (Object[])new Object[]{object.getClass().getName()}));
    }

    public static RelationshipProjection of(String type, Orientation orientation) {
        return RelationshipProjection.builder().type(type).orientation(orientation).build();
    }

    public static RelationshipProjection of(String type, Aggregation aggregation) {
        return RelationshipProjection.builder().type(type).aggregation(aggregation).build();
    }

    public boolean isMultiGraph() {
        boolean somePropertyIsNotAggregated = this.properties().mappings().stream().anyMatch(m -> Aggregation.equivalentToNone(m.aggregation()));
        return Aggregation.equivalentToNone(this.aggregation()) && (this.properties().isEmpty() || somePropertyIsNotAggregated);
    }

    @Override
    boolean includeAggregation() {
        return true;
    }

    @Override
    void writeToObject(Map<String, Object> value) {
        value.put(TYPE_KEY, this.type());
        value.put(ORIENTATION_KEY, this.orientation().name());
        value.put(AGGREGATION_KEY, this.aggregation().name());
    }

    @Override
    public RelationshipProjection withAdditionalPropertyMappings(PropertyMappings mappings) {
        PropertyMappings withSameAggregation = PropertyMappings.builder().from(mappings).withDefaultAggregation(this.aggregation()).build();
        PropertyMappings newMappings = this.properties().mergeWith(withSameAggregation);
        return newMappings.equals(this.properties()) ? RelationshipProjection.copyOf(this) : RelationshipProjection.copyOf(this).withProperties(newMappings);
    }

    public static RelationshipProjection all() {
        return ALL;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static RelationshipProjection create(Map<String, Object> config, Aggregation defaultAggregation, Function<PropertyMappings, RelationshipProjection> constructor) {
        Map properties = config.getOrDefault("properties", Collections.emptyMap());
        PropertyMappings propertyMappings = PropertyMappings.fromObject(properties, defaultAggregation);
        return constructor.apply(propertyMappings);
    }

    private static void validateConfigKeys(Map<String, Object> map) {
        ConfigKeyValidation.requireOnlyKeysFrom(List.of(TYPE_KEY, ORIENTATION_KEY, AGGREGATION_KEY, "properties"), map.keySet());
    }

    @Builder.AccessibleFields
    public static final class Builder
    extends RelationshipProjection.Builder
    implements ElementProjection.InlineProperties<Builder> {
        private ElementProjection.InlinePropertiesBuilder propertiesBuilder;

        Builder() {
        }

        @Override
        public RelationshipProjection build() {
            this.buildProperties();
            return super.build();
        }

        @Override
        public ElementProjection.InlinePropertiesBuilder inlineBuilder() {
            if (this.propertiesBuilder == null) {
                this.propertiesBuilder = new ElementProjection.InlinePropertiesBuilder(() -> this.properties, newProperties -> {
                    this.properties = newProperties;
                });
            }
            return this.propertiesBuilder;
        }
    }
}

